/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user.migration;

import com.atlassian.user.util.migration.MigrationProgressListener;
import java.io.IOException;
import javax.servlet.jsp.JspWriter;
import org.apache.log4j.Logger;

public class HtmlJspWriterMigrationProgressListener
implements MigrationProgressListener {
    protected final transient Logger log = Logger.getLogger(this.getClass());
    private final JspWriter jspWriter;
    private int usersToMigrate;
    private int migratedUsers = 0;
    private int groupsToMigrate;
    private int migratedGroups = 0;

    public HtmlJspWriterMigrationProgressListener(JspWriter jspWriter) {
        if (jspWriter == null) {
            throw new IllegalArgumentException("JspWriter must NOT be null!");
        }
        this.jspWriter = jspWriter;
    }

    public void userMigrationStarted(int usersToMigrate) {
        this.usersToMigrate = usersToMigrate;
        this.printToJspWriter("<p>Beginning user migration. <strong>" + this.usersToMigrate + "</strong> users to migrate.</p><ul>");
    }

    public void userMigrated() {
        if (++this.migratedUsers % 100 == 0) {
            this.printToJspWriter("<li>" + this.migratedUsers + " users migrated<li>");
        }
    }

    public void userMigrationComplete() {
        this.printToJspWriter("</ul><p>User migration completed.</p><br/><br/><br/>");
    }

    public void groupMigrationStarted(int groupsToMigrate) {
        this.groupsToMigrate = groupsToMigrate;
        this.printToJspWriter("<p>Beginning group migration. <strong>" + this.groupsToMigrate + "</strong> groups to migrate.</p><ul>");
    }

    public void groupMigrated() {
        if (++this.migratedGroups % 100 == 0) {
            this.printToJspWriter("<li>" + this.migratedGroups + " groups migrated<li>");
        }
    }

    public void groupMigrationComplete() {
        this.printToJspWriter("</ul><p>Group migration completed.</p><br/><br/><br/>");
    }

    public void readonlyGroupMembershipNotMigrated(String groupName, String userName) {
        this.log.warn((Object)("Could not migrate goup membership for user <" + userName + "> and group <" + groupName + ">. " + "Group is readonly, it is possibly a LDAP group."));
        this.printToJspWriter("<p>Could not migrate goup membership for user &lt;" + userName + "&gt; and group &lt;" + groupName + "&gt;. Group is readonly, it is possibly a LDAP group.</p>");
    }

    private void printToJspWriter(String htmlMessage) {
        try {
            this.jspWriter.print(htmlMessage);
            this.jspWriter.flush();
        }
        catch (IOException e) {
            throw new HtmlJspWriterMigrationProgressListenerException(e);
        }
    }

    private static class HtmlJspWriterMigrationProgressListenerException
    extends RuntimeException {
        public HtmlJspWriterMigrationProgressListenerException(Throwable throwable) {
            super(throwable);
        }
    }
}

