/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user.providers.jira;

import com.atlassian.core.db.JDBCUtils;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.propertyset.PropertySetManager;
import com.opensymphony.user.provider.hibernate.OSUserHibernateConfigurationProvider;
import com.opensymphony.user.provider.hibernate.impl.OSUserHibernateConfigurationProviderImpl;
import com.opensymphony.user.provider.jdbc.JDBCProfileProvider;
import com.opensymphony.util.ClassLoaderUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Category;

public class JiraJdbcProfileProvider
extends JDBCProfileProvider {
    private static final Category log = Category.getInstance(JiraJdbcProfileProvider.class);
    OSUserHibernateConfigurationProvider configProvider;
    private String idCol;
    private String membershipIdCol;

    public boolean init(Properties props) {
        boolean result = super.init(props);
        if (result) {
            this.userTable = props.getProperty("userTable");
            if (this.userTable == null) {
                this.userTable = "userbase";
            }
            if ((this.idCol = props.getProperty("userId")) == null) {
                this.idCol = "id";
            }
            if ((this.userName = props.getProperty("userName")) == null) {
                this.userName = "userName";
            }
            if ((this.userPassword = props.getProperty("userPassword")) == null) {
                this.userPassword = "password_hash";
            }
            if ((this.groupTable = props.getProperty("groupTable")) == null) {
                this.groupTable = "groupbase";
            }
            if ((this.groupName = props.getProperty("groupName")) == null) {
                this.groupName = "groupname";
            }
            if ((this.membershipTable = props.getProperty("membershipTable")) == null) {
                this.membershipTable = "membershipbase";
            }
            if ((this.membershipIdCol = props.getProperty("membershipId")) == null) {
                this.membershipIdCol = "userId";
            }
            if ((this.membershipUserName = props.getProperty("membershipUserName")) == null) {
                this.membershipUserName = "user_name";
            }
            if ((this.membershipGroupName = props.getProperty("membershipGroupName")) == null) {
                this.membershipGroupName = "group_name";
            }
            String configProviderClass = props.getProperty("configuration.provider.class");
            this.configProvider = null;
            if (configProviderClass != null) {
                try {
                    this.configProvider = (OSUserHibernateConfigurationProvider)ClassLoaderUtil.loadClass((String)configProviderClass, ((Object)((Object)this)).getClass()).newInstance();
                }
                catch (Exception e) {
                    log.error((Object)("Unable to load configuration provider class: " + configProviderClass), (Throwable)e);
                    return false;
                }
            } else {
                this.configProvider = new OSUserHibernateConfigurationProviderImpl();
            }
            this.configProvider.setupConfiguration((Map)props);
        }
        return result;
    }

    public PropertySet getPropertySet(String name) {
        long userId = this.lookupUserIdForName(name);
        if (userId == -1L) {
            log.fatal((Object)("Could not find property set for " + name));
            return null;
        }
        PropertySet jiraPs = this.getJiraPropertySet(name, userId);
        PropertySet confluencePs = this.getConfluencePropertySet(name, userId);
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("default", jiraPs);
        args.put("conditional", confluencePs);
        args.put("condition", "confluence.");
        return PropertySetManager.getInstance((String)"conditional", args);
    }

    private PropertySet getConfluencePropertySet(String name, long userId) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("entityId", new Long(userId));
        args.put("entityName", "OSUser_user");
        args.put("configurationProvider", this.configProvider);
        return PropertySetManager.getInstance((String)"hibernate", args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long lookupUserIdForName(String name) {
        long l;
        PreparedStatement ps;
        Connection conn;
        block8: {
            long l2;
            block7: {
                conn = null;
                ps = null;
                try {
                    conn = this.ds.getConnection();
                    ps = conn.prepareStatement("SELECT " + this.idCol + " FROM " + this.userTable + " WHERE " + this.userName + " = ?");
                    ps.setString(1, name);
                    ResultSet rs = ps.executeQuery();
                    if (rs.next()) {
                        l2 = rs.getLong(1);
                        JDBCUtils.close((Statement)ps);
                        break block7;
                    }
                    l = -1L;
                    JDBCUtils.close((Statement)ps);
                    break block8;
                }
                catch (SQLException e) {
                    log.fatal((Object)("Could not see if [" + name + "] is handled"), (Throwable)e);
                    long l3 = -1L;
                    return l3;
                }
            }
            JDBCUtils.close((Connection)conn);
            return l2;
        }
        JDBCUtils.close((Connection)conn);
        return l;
        finally {
            JDBCUtils.close(ps);
            JDBCUtils.close((Connection)conn);
        }
    }

    private PropertySet getJiraPropertySet(String name, long userId) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("username", name);
        args.put("userid", new Long(userId));
        args.put("datasource", this.ds);
        return PropertySetManager.getInstance((String)"jirajdbc", args);
    }
}

