/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.PageContentEntityObject;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.util.LinkRenamingBean;
import com.atlassian.renderer.v2.WikiMarkupParser;
import com.atlassian.renderer.v2.components.MacroTag;
import com.atlassian.renderer.v2.components.WikiContentHandler;
import com.atlassian.renderer.v2.macro.Macro;
import com.atlassian.renderer.v2.macro.MacroManager;
import com.opensymphony.util.TextUtils;

public abstract class AbstractLinkRenamingBean
implements LinkRenamingBean,
WikiContentHandler {
    protected SpaceContentEntityObject pageBeingChanged;
    protected String newSpaceKey;
    protected String newTitle;
    protected ContentEntityObject referringContent;
    private MacroManager macroManager;
    private WikiMarkupParser parser;

    public AbstractLinkRenamingBean(ContentEntityObject referringContent, SpaceContentEntityObject pageBeingChanged, String newSpaceKey, String newTitle) {
        this.pageBeingChanged = pageBeingChanged;
        this.newSpaceKey = newSpaceKey;
        this.newTitle = newTitle;
        this.referringContent = referringContent;
    }

    protected String getReferringContentSpaceKey() {
        if (this.referringContent instanceof SpaceContentEntityObject) {
            return ((SpaceContentEntityObject)this.referringContent).getSpaceKey();
        }
        if (this.referringContent instanceof PageContentEntityObject) {
            return ((PageContentEntityObject)this.referringContent).getPage().getSpaceKey();
        }
        return "";
    }

    protected SpaceContentEntityObject getPageBeingChanged() {
        return this.pageBeingChanged;
    }

    protected String escapeDollars(String s) {
        StringBuffer buf = new StringBuffer(s.length() + 5);
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '$') {
                buf.append('\\');
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public String getRenamedContent() {
        return this.parseContent(this.referringContent.getContent());
    }

    public void setMacroManager(MacroManager macroManager) {
        this.macroManager = macroManager;
    }

    public void handleMacro(StringBuffer buffer, MacroTag macroTag, String body, boolean hasEndTag) {
        assert (macroTag.command != null);
        Macro macro = this.macroManager.getEnabledMacro(macroTag.command.toLowerCase());
        buffer.append('{' + macroTag.command);
        if (TextUtils.stringSet((String)macroTag.argString)) {
            buffer.append(':' + macroTag.argString);
        }
        String newBody = macro != null && macro.hasBody() && (macro.getBodyRenderMode() == null || macro.getBodyRenderMode().renderLinks()) ? this.parseContent(body) : body;
        buffer.append('}' + newBody);
        if (hasEndTag) {
            buffer.append('{' + macroTag.command + '}');
        }
    }

    public abstract void handleText(StringBuffer var1, String var2);

    private String parseContent(String content) {
        if (this.parser == null) {
            this.parser = new WikiMarkupParser(this.macroManager, (WikiContentHandler)this);
        }
        return this.parser.parse(content);
    }
}

