/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util;

import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.xwork.FileUploadUtils;
import com.opensymphony.util.TextUtils;
import com.opensymphony.webwork.dispatcher.multipart.MultiPartRequestWrapper;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttachFileHelper {
    private MultiPartRequestWrapper multipartRequestWrapper;
    private Set<String> errors = new HashSet<String>();
    private List<FileUploadUtils.UploadedFile> uploadedFiles = new ArrayList<FileUploadUtils.UploadedFile>();
    private Map<String, String> filenameToCommentMap = new HashMap<String, String>();
    private int maxAttachments;
    private static final char[] INVALID_FILENAME_CHARACTERS = new char[]{'&', '+', '?', '|', '='};

    public AttachFileHelper(MultiPartRequestWrapper multipartRequestWrapper, int maxAttachments) {
        this.multipartRequestWrapper = multipartRequestWrapper;
        this.maxAttachments = maxAttachments;
        this.initUploadedFiles();
        this.validateAttachments();
    }

    public List<FileUploadUtils.UploadedFile> getUploadedFiles() {
        return this.uploadedFiles;
    }

    public void initUploadedFiles() {
        try {
            FileUploadUtils.UploadedFile[] filesAsArray = FileUploadUtils.handleFileUpload((MultiPartRequestWrapper)this.multipartRequestWrapper, (boolean)true);
            this.uploadedFiles = new ArrayList<FileUploadUtils.UploadedFile>(Arrays.asList(filesAsArray));
        }
        catch (FileUploadUtils.FileUploadException e) {
            for (int j = 0; j < e.getErrors().length; ++j) {
                this.errors.add(GeneralUtil.getUploadFileTooLargeMessage(e.getErrors()[j]));
            }
        }
    }

    private void validateAttachments() {
        for (int i = 0; i < this.maxAttachments; ++i) {
            String[] fileNames = this.multipartRequestWrapper.getFileNames("file_" + i);
            if (fileNames == null || fileNames.length == 0) continue;
            String fileName = fileNames[0];
            String comment = this.multipartRequestWrapper.getParameter("comment_" + i);
            Collection<String> fileValidationErrors = this.verifyFile(fileName);
            for (String error : fileValidationErrors) {
                this.errors.add(error);
                this.removeUploadedFile(fileName);
            }
            if (TextUtils.stringSet((String)comment) && comment.length() > 255) {
                this.errors.add(fileName + " could not be uploaded because its comment was longer than 255 characters.");
                this.removeUploadedFile(fileName);
                continue;
            }
            this.filenameToCommentMap.put(fileName, comment);
        }
    }

    public String getCommentForFilename(String filename) {
        return this.filenameToCommentMap.get(filename);
    }

    public Collection<String> getErrors() {
        return this.errors;
    }

    private Collection<String> verifyFile(String fileName) {
        ArrayList<String> fileErrors = new ArrayList<String>();
        if (TextUtils.stringSet((String)fileName)) {
            if (!AttachFileHelper.isValidFileName(fileName)) {
                fileErrors.add(MessageFormat.format("{0} contains illegal characters ('&', '+', '?', '|' or '='). You cannot upload files with names containing these characters.", fileName));
            }
            boolean valid = false;
            for (FileUploadUtils.UploadedFile uploadedFile : this.getUploadedFiles()) {
                if (!fileName.equals(uploadedFile.getFileName())) continue;
                valid = true;
                break;
            }
            if (!valid) {
                fileErrors.add(fileName + " does not exist.");
            }
        }
        return fileErrors;
    }

    public static boolean isValidFileName(String fileName) {
        if (StringUtils.isBlank((String)fileName)) {
            return false;
        }
        return StringUtils.containsNone((String)fileName, (char[])INVALID_FILENAME_CHARACTERS);
    }

    private void removeUploadedFile(String filename) {
        Iterator<FileUploadUtils.UploadedFile> iterator = this.getUploadedFiles().iterator();
        while (iterator.hasNext()) {
            if (!TextUtils.noNull((String)filename).equals(iterator.next().getFileName())) continue;
            iterator.remove();
        }
    }
}

