/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaPersister;
import com.atlassian.confluence.setup.BootstrapUtils;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.setup.bandana.FileBandanaXmlParser;
import com.atlassian.confluence.setup.xstream.XStreamManager;
import com.atlassian.core.util.FileUtils;
import java.io.File;
import java.io.FileFilter;
import java.util.Map;
import org.apache.log4j.Category;

public class BandanaConfigMigrator {
    public static final Category log = Category.getInstance(BandanaConfigMigrator.class);
    private XStreamManager xStreamManager;
    private BandanaPersister persister;

    public void run() {
        this.run(new File(BootstrapUtils.getBootstrapManager().getConfluenceHome() + "/config/"));
    }

    public void run(File baseConfigPath) {
        if (baseConfigPath == null || !baseConfigPath.exists()) {
            return;
        }
        FileBandanaXmlParser bandanaXmlParser = new FileBandanaXmlParser(baseConfigPath);
        Map globalBandanaEntries = bandanaXmlParser.getEntries(ConfluenceBandanaContext.GLOBAL_CONTEXT);
        for (Map.Entry entry : globalBandanaEntries.entrySet()) {
            String xmlValue = (String)entry.getValue();
            Object value = this.xStreamManager.getXstream().fromXML(xmlValue);
            this.persister.store((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, (String)entry.getKey(), value);
        }
        File globalConfigFile = new File(baseConfigPath, "confluence-global.bandana.xml");
        globalConfigFile.delete();
        File[] subDirs = baseConfigPath.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        for (int i = 0; i < subDirs.length; ++i) {
            String spaceKey = subDirs[i].getName();
            ConfluenceBandanaContext context = new ConfluenceBandanaContext(spaceKey);
            Map spaceBandanaEntries = bandanaXmlParser.getEntries(context);
            for (Map.Entry entry : spaceBandanaEntries.entrySet()) {
                String xmlValue = (String)entry.getValue();
                Object value = this.xStreamManager.getXstream().fromXML(xmlValue);
                this.persister.store((BandanaContext)context, (String)entry.getKey(), value);
            }
            FileUtils.deleteDir((File)subDirs[i]);
        }
    }

    public void setBandanaPersister(BandanaPersister persister) {
        this.persister = persister;
    }

    public void setxStreamManager(XStreamManager xStreamManager) {
        this.xStreamManager = xStreamManager;
    }
}

