/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util;

import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.spring.container.ContainerManager;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

public class ClusterHeaderFilter
implements Filter {
    private static final String HEADER_NAME = "X-Confluence-Cluster-Node";

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        try {
            String value = this.getClusterNodeDescription();
            if (value != null) {
                ((HttpServletResponse)servletResponse).addHeader(HEADER_NAME, value);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        chain.doFilter(servletRequest, servletResponse);
    }

    private String getClusterNodeDescription() throws Exception {
        if (!ContainerManager.isContainerSetup()) {
            return null;
        }
        ClusterManager clusterManager = (ClusterManager)ContainerManager.getComponent((String)"clusterManager");
        if (!clusterManager.isClustered()) {
            return null;
        }
        return clusterManager.getThisNodeInformation().getDescription();
    }

    public void destroy() {
    }
}

