/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util;

import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.core.bean.EntityObject;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ContentUtils {
    public static List mergeContentObjects(Iterator it1, Iterator it2, int maxSize) {
        ConfluenceEntityObject c1 = null;
        ConfluenceEntityObject c2 = null;
        ArrayList<ConfluenceEntityObject> results = new ArrayList<ConfluenceEntityObject>(maxSize);
        while (results.size() < maxSize && (it1.hasNext() || it2.hasNext())) {
            ConfluenceEntityObject latest;
            if (c1 == null && it1.hasNext()) {
                c1 = (ConfluenceEntityObject)it1.next();
            }
            if (c2 == null && it2.hasNext()) {
                c2 = (ConfluenceEntityObject)it2.next();
            }
            if ((latest = ContentUtils.getLatest(c1, c2)) == null) break;
            if (latest == c1) {
                c1 = null;
            } else {
                c2 = null;
            }
            results.add(latest);
        }
        return results;
    }

    public static ConfluenceEntityObject getLatest(ConfluenceEntityObject c1, ConfluenceEntityObject c2) {
        if (c1 == null) {
            return c2;
        }
        if (c2 == null) {
            return c1;
        }
        if (new Timestamp(c1.getLastModificationDate().getTime()).compareTo(new Timestamp(c2.getLastModificationDate().getTime())) > 0) {
            return c1;
        }
        return c2;
    }

    public static List getEntityObjectsIds(List entityObjectList) {
        ArrayList<Long> spaceIds = new ArrayList<Long>();
        for (int i = 0; i < entityObjectList.size(); ++i) {
            EntityObject entity = (EntityObject)entityObjectList.get(i);
            spaceIds.add(new Long(entity.getId()));
        }
        return spaceIds;
    }
}

