/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util;

import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.confluence.importexport.FopConfigurationFactory;
import com.atlassian.confluence.util.FontManager;
import com.atlassian.core.util.FileUtils;
import com.opensymphony.util.TextUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.fonts.apps.TTFReader;
import org.apache.fop.fonts.truetype.FontFileReader;
import org.apache.fop.fonts.truetype.TTFFile;
import org.apache.log4j.Category;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class DefaultFontManager
implements FontManager {
    public static final Category log = Category.getInstance(DefaultFontManager.class);
    public static final String DEFAULT_FONT = "Verdana";
    private FopFactory fopFactory;
    private FopConfigurationFactory fopConfigurationFactory;

    public void installFont(File candidateFontFile) throws IOException, FOPException {
        this.installFont((Resource)new FileSystemResource(candidateFontFile));
    }

    public void installFont(Resource fontResource) throws IOException, FOPException {
        if (!fontResource.exists()) {
            throw new IOException("Attempting to install a font file that does not exist: " + fontResource.getDescription());
        }
        try {
            File installedFontFile = new File(DefaultFontManager.getBaseFontsDir(), fontResource.getFilename());
            if (!installedFontFile.exists()) {
                FileUtils.copyFile((InputStream)fontResource.getInputStream(), (File)installedFontFile);
            }
            Font installedFont = new Font(installedFontFile);
            this.buildFontMetrics(installedFont);
            this.writeCustomFopConfig(installedFont);
            this.fopFactory.setUserConfig(this.fopConfigurationFactory.getConfiguration());
        }
        catch (IOException ioException) {
            this.restoreDefaultFont();
            throw ioException;
        }
        catch (FOPException fopException) {
            this.restoreDefaultFont();
            throw fopException;
        }
    }

    public void restoreDefaultFont() throws FOPException {
        File baseFontsDir = DefaultFontManager.getBaseFontsDir();
        if (baseFontsDir.exists()) {
            FileUtils.deleteDir((File)baseFontsDir);
        }
        this.fopFactory.setUserConfig(this.fopConfigurationFactory.getConfiguration());
    }

    private void buildFontMetrics(Font font) throws IOException {
        ArrayList<String> ttfReaderArgs = new ArrayList<String>();
        ttfReaderArgs.add(font.getFile().getAbsolutePath());
        ttfReaderArgs.add(new File(DefaultFontManager.getBaseFontsDir(), font.getName() + "-metrics.xml").getAbsolutePath());
        if (Boolean.getBoolean("pdf.clipboard.enable")) {
            ttfReaderArgs.add("-enc");
            ttfReaderArgs.add("ansi");
        }
        if ("TTC".equalsIgnoreCase(font.getExtension())) {
            ttfReaderArgs.add("-ttcname");
            List fontNames = this.getFontNamesFromTTC(font.getFile());
            if (fontNames.size() > 0) {
                ttfReaderArgs.add((String)fontNames.get(0));
            } else {
                throw new IllegalArgumentException("Could not determine font names inside TTC font file: " + font.getName());
            }
        }
        String[] ttfReaderArgsAsStringArray = new String[ttfReaderArgs.size()];
        ttfReaderArgs.toArray(ttfReaderArgsAsStringArray);
        TTFReader.main((String[])ttfReaderArgsAsStringArray);
    }

    public String getCurrentFont() {
        if (this.isCustomFontInstalled()) {
            try {
                return this.fopFactory.getUserConfig().getChild("renderers").getChild("renderer").getChild("fonts").getChild("font").getChild("font-triplet").getAttribute("name");
            }
            catch (ConfigurationException e) {
                log.error((Object)"Error determining the name of the custom font, using default font.", (Throwable)e);
            }
        }
        return DEFAULT_FONT;
    }

    public boolean isCustomFontInstalled() {
        return new File(DefaultFontManager.getBaseFontsDir(), "fop.xml").isFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeCustomFopConfig(Font font) throws IOException {
        Document document = DocumentHelper.createDocument();
        Element rendererElement = document.addElement("fop").addElement("renderers").addElement("renderer").addAttribute("mime", "application/pdf");
        Element fontsElement = rendererElement.addElement("fonts");
        Element fontElement = fontsElement.addElement("font");
        String fontMetricsUrl = new File(DefaultFontManager.getBaseFontsDir(), font.getName() + "-metrics.xml").toURL().toString();
        fontElement.addAttribute("metrics-url", fontMetricsUrl);
        fontElement.addAttribute("embed-url", font.getURL());
        fontElement.addAttribute("kerning", "yes");
        fontElement.addElement("font-triplet").addAttribute("name", font.getName()).addAttribute("style", "normal").addAttribute("weight", "normal");
        fontElement.addElement("font-triplet").addAttribute("name", font.getName()).addAttribute("style", "normal").addAttribute("weight", "bold");
        fontElement.addElement("font-triplet").addAttribute("name", font.getName()).addAttribute("style", "italic").addAttribute("weight", "normal");
        fontElement.addElement("font-triplet").addAttribute("name", font.getName()).addAttribute("style", "italic").addAttribute("weight", "bold");
        XMLWriter writer = null;
        try {
            writer = new XMLWriter((Writer)new FileWriter(new File(DefaultFontManager.getBaseFontsDir(), "fop.xml")), OutputFormat.createPrettyPrint());
            writer.write(document);
        }
        catch (IOException e) {
            log.error((Object)"Error writing changes to fop.xml in Confluence home.", (Throwable)e);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    private List getFontNamesFromTTC(File font) throws IOException {
        return new TTFFile().getFontNames(new FontFileReader(font.getAbsolutePath()));
    }

    public static File getBaseFontsDir() {
        return new File(BootstrapUtils.getBootstrapManager().getApplicationHome() + File.separator + "fonts");
    }

    public void setFopFactory(FopFactory fopFactory) {
        this.fopFactory = fopFactory;
    }

    public void setFopConfigurationFactory(FopConfigurationFactory fopConfigurationFactory) {
        this.fopConfigurationFactory = fopConfigurationFactory;
    }

    private class Font {
        private File fontFile;
        private String filename;

        public Font(File fontFile) {
            if (fontFile == null || !fontFile.isFile()) {
                throw new IllegalArgumentException("Font file specified is null, does not exist or is not a file.");
            }
            this.fontFile = fontFile;
            this.filename = fontFile.getName();
            if (!"TTF".equalsIgnoreCase(this.getExtension()) && !"TTC".equalsIgnoreCase(this.getExtension())) {
                throw new IllegalArgumentException(fontFile.getName() + " is not a supported font file.");
            }
        }

        public String getName() {
            return this.filename.substring(0, this.filename.lastIndexOf(this.getExtension()) - 1);
        }

        public String getExtension() {
            int indexOfDot;
            String extension = null;
            if (TextUtils.stringSet((String)this.filename) && (indexOfDot = this.filename.lastIndexOf(".")) != -1 && indexOfDot != this.filename.length() - 1) {
                extension = this.filename.substring(indexOfDot + 1);
            }
            return extension;
        }

        public String getFilename() {
            return this.filename;
        }

        public File getFile() {
            return this.fontFile;
        }

        public String getURL() throws MalformedURLException {
            return this.fontFile.toURL().toString();
        }
    }
}

