/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.event.events.space.SpaceRemoveEvent;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.Resource;
import com.atlassian.confluence.util.ResourceManager;
import com.atlassian.confluence.util.io.IOUtils;
import com.atlassian.core.util.FileUtils;
import com.atlassian.event.Event;
import com.atlassian.event.EventListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Category;
import org.springframework.core.io.FileSystemResource;

public class DefaultResourceManager
implements ResourceManager,
EventListener {
    private static final Category log = Category.getInstance(DefaultResourceManager.class);
    private static final Class[] handledEventClasses = new Class[]{SpaceRemoveEvent.class};
    private BandanaManager bandanaManager;
    private BootstrapManager bootstrapManager;
    private SpaceManager spaceManager;

    public Resource getResourceWithSpaceKey(String key, String spaceKey) {
        return this.getResource(key, this.spaceManager.getSpace(spaceKey));
    }

    public void deleteAllSpaceResources(String spaceKey) {
        File spaceResources = new File(this.getResourceDirPath() + File.separator + spaceKey);
        if (spaceResources.exists()) {
            FileUtils.recursiveDelete((File)spaceResources);
        }
    }

    public void addResource(String key, File resourceFile, Space space) {
        this.addResource(key, resourceFile, space, null);
    }

    public void addResource(String key, org.springframework.core.io.Resource resource, Space space) {
        this.addResource(key, resource, space, null);
    }

    public void addResource(String key, File resourceFile, Space space, String contentTypePrefix) {
        this.addResource(key, (org.springframework.core.io.Resource)new FileSystemResource(resourceFile), space, contentTypePrefix);
    }

    public void addResource(String key, org.springframework.core.io.Resource resourceFile, Space space, String contentTypePrefix) {
        try {
            this.locateResourcesDir(space);
        }
        catch (Exception e) {
            log.fatal((Object)e);
            return;
        }
        ConfluenceBandanaContext bandanaContext = new ConfluenceBandanaContext(space);
        ArrayList<Resource> resources = this.getResourceList(bandanaContext);
        Resource resource = null;
        if (resources == null) {
            resources = new ArrayList<Resource>();
        } else {
            resource = this.findMatchingUserResource(resources, key);
        }
        try {
            this.storeResource(resourceFile, space);
        }
        catch (IOException e) {
            log.error((Object)("Could not store resource [" + resourceFile.getFilename() + "]"));
            return;
        }
        if (resource == null) {
            resource = new Resource();
            resources.add(resource);
        } else if (!resource.getRelativePathToFile().equals(resourceFile.getFilename())) {
            this.getResourceFile(resource.getRelativePathToFile()).delete();
        }
        resource.setKey(key);
        if (space == null) {
            resource.setRelativePathToFile(resourceFile.getFilename());
        } else {
            resource.setRelativePathToFile(resourceFile.getFilename());
        }
        resource.setContentTypePrefix(contentTypePrefix);
        this.bandanaManager.setValue((BandanaContext)bandanaContext, "atlassian.confluence.user.resources", resources);
    }

    private List getResourceList(BandanaContext bandanaContext) {
        return (List)this.bandanaManager.getValue(bandanaContext, "atlassian.confluence.user.resources", false);
    }

    private Resource findMatchingUserResource(List resources, String key) {
        Iterator iter = resources.iterator();
        Resource resource = null;
        while (iter.hasNext()) {
            Resource searchResource = (Resource)iter.next();
            if (!searchResource.getKey().equals(key)) continue;
            resource = searchResource;
            break;
        }
        return resource;
    }

    public Resource getResource(String key, Space space) {
        ConfluenceBandanaContext bandanaContext = new ConfluenceBandanaContext(space);
        List resources = this.getResourceList(bandanaContext);
        if (resources == null) {
            return null;
        }
        Resource matchingResource = this.findMatchingUserResource(resources, key);
        if (matchingResource == null) {
            return null;
        }
        return matchingResource;
    }

    public void removeResource(String key, Space space) {
        Resource resource = this.getResource(key, space);
        ConfluenceBandanaContext bandanaContext = new ConfluenceBandanaContext(space);
        List resources = this.getResourceList(bandanaContext);
        resources.remove(resource);
        this.getResourceFile(resource.getRelativePathToFile(), space).delete();
        this.bandanaManager.setValue((BandanaContext)bandanaContext, "atlassian.confluence.user.resources", (Object)resources);
    }

    private void storeResource(org.springframework.core.io.Resource resourceToBeAdded, Space space) throws IOException {
        InputStream is = resourceToBeAdded.getInputStream();
        FileOutputStream fios = space == null ? new FileOutputStream(new File(this.getResourceDirPath() + File.separator + resourceToBeAdded.getFilename())) : new FileOutputStream(new File(this.getResourceDirPath() + File.separator + space.getKey() + File.separator + resourceToBeAdded.getFilename()));
        IOUtils.copy(is, fios);
    }

    private String getResourceDirPath() {
        return this.bootstrapManager.getConfluenceHome() + File.separator + "resources";
    }

    private File locateResourcesDir(Space space) throws Exception {
        File dir = space == null ? new File(this.bootstrapManager.getConfluenceHome() + File.separator + "resources") : new File(this.bootstrapManager.getConfluenceHome() + File.separator + "resources" + File.separator + space.getKey());
        this.validateDirExists(dir);
        return dir;
    }

    private void validateDirExists(File dir) throws Exception {
        if (dir.exists() && !dir.isDirectory()) {
            throw new Exception("a file named " + dir + " already exists within " + this.bootstrapManager.getConfluenceHome() + " and is not a directory.");
        }
        if (!dir.exists()) {
            try {
                if (!dir.mkdirs()) {
                    throw new Exception("Could not create " + dir + "! The process running Confluence should have permission to create directories beneath " + this.bootstrapManager.getConfluenceHome());
                }
            }
            catch (SecurityException e) {
                throw new Exception("Could not create " + dir + "! The process running Confluence should have permission to create directories beneath " + this.bootstrapManager.getConfluenceHome(), e);
            }
        }
    }

    private void cleanUpTempDir(File resourceFile) {
        File tempFile = new File(GeneralUtil.getConfluenceTempDirectory(), resourceFile.getName());
        if (tempFile.exists()) {
            tempFile.delete();
        }
    }

    public File getResourceFile(String relativePathToFile) {
        return this.getResourceFile(relativePathToFile, null);
    }

    public File getResourceFile(String relativePathToFile, Space space) {
        File resourceFile = space == null ? new File(this.bootstrapManager.getConfluenceHome() + File.separator + "resources" + File.separator + relativePathToFile) : new File(this.bootstrapManager.getConfluenceHome() + File.separator + "resources" + File.separator + space.getKey() + File.separator + relativePathToFile);
        return resourceFile;
    }

    public void setBandanaManager(BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
    }

    public void setBootstrapManager(BootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public void handleEvent(Event event) {
        if (event instanceof SpaceRemoveEvent) {
            this.deleteAllSpaceResources(((SpaceRemoveEvent)event).getSpace().getKey());
        }
    }

    public Class[] getHandledEventClasses() {
        return handledEventClasses;
    }
}

