/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.LabelParser;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.labels.Labelling;
import com.atlassian.confluence.labels.Namespace;
import com.atlassian.confluence.labels.ParsedLabelName;
import com.atlassian.confluence.labels.PermittedLabelView;
import com.atlassian.confluence.labels.SpecialLabelFilter;
import com.atlassian.confluence.labels.VisibleLabelFilter;
import com.atlassian.confluence.labels.persistence.dao.LabelSearchResult;
import com.atlassian.confluence.labels.persistence.dao.RankedLabelSearchResult;
import com.atlassian.confluence.user.history.UserHistory;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.core.util.filter.Filter;
import com.atlassian.core.util.filter.FilterChain;
import com.atlassian.core.util.filter.ListFilter;
import com.atlassian.user.User;
import com.opensymphony.util.TextUtils;
import com.opensymphony.xwork.ActionContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.set.ListOrderedSet;
import org.apache.commons.lang.StringUtils;

public final class LabelUtil {
    public static final String LABEL_DELIM_CHARS = " ,";
    public static final String LABEL_DELIM = " ";
    public static final int MAX_ALLOWED_LABELS_PER_INPUT = 20;
    public static final int MAX_ALLOWED_LABELS = 500;

    public static String convertToDelimitedString(Labelable obj, User user) {
        List labels = new PermittedLabelView(obj, user, true).getLabels();
        LinkedList<String> names = new LinkedList<String>();
        for (int i = 0; i < labels.size(); ++i) {
            Label label = (Label)labels.get(i);
            if (Namespace.isPersonal(label)) {
                names.add("my:" + label.getName());
                continue;
            }
            names.add(label.getName());
        }
        return StringUtils.join(names.iterator(), (String)LABEL_DELIM);
    }

    public static String convertToDelimitedString(Labelable obj, User user, LabelManager labelManager) {
        return LabelUtil.convertToDelimitedString(obj, user);
    }

    public static String convertToDelimitedString(List names) {
        StringBuffer buffer = new StringBuffer(20);
        String sep = "";
        for (int i = 0; i < names.size(); ++i) {
            buffer.append(sep);
            buffer.append(names.get(i));
            sep = LABEL_DELIM;
        }
        return buffer.toString().trim();
    }

    public static String joinIds(List labels, String separator) {
        String joinedIds = "";
        for (Label label : labels) {
            if (StringUtils.isNotEmpty((String)joinedIds)) {
                joinedIds = joinedIds + separator;
            }
            joinedIds = joinedIds + label.getId();
        }
        return joinedIds;
    }

    public static boolean isValidLabelNames(String delimitedLabelNames) {
        return LabelUtil.isValidLabelNames(LabelUtil.split(delimitedLabelNames));
    }

    public static boolean isValidLabelNames(Collection names) {
        Iterator i = names.iterator();
        while (i.hasNext()) {
            if (LabelUtil.isValidLabelName((String)i.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidLabelName(String labelName) {
        if (labelName == null) {
            return false;
        }
        if ((labelName = labelName.trim()).length() == 0) {
            return false;
        }
        return LabelParser.parse(labelName) != null;
    }

    public static boolean isValidLabelLengths(String concatenatedLabelNames) {
        return LabelUtil.isValidLabelLengths(LabelUtil.split(concatenatedLabelNames));
    }

    public static boolean isValidLabelLengths(Collection labelNames) {
        Iterator i = labelNames.iterator();
        while (i.hasNext()) {
            if (LabelUtil.isValidLabelLength((String)i.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidLabelLength(String input) {
        ParsedLabelName parsedLabelName = LabelParser.parse(input.trim());
        return parsedLabelName != null && LabelParser.isValidLabelLength(parsedLabelName);
    }

    public static List getVisibleLabelNames(List labels, String username) {
        ArrayList<String> returnedLabelNames = new ArrayList<String>(labels.size());
        for (Label label : labels) {
            Namespace namespace = label.getNamespace();
            if (Namespace.GLOBAL.equals(namespace)) {
                returnedLabelNames.add(label.getName());
                continue;
            }
            if (!LabelUtil.labelIsVisibleToUser(namespace, label, username)) continue;
            returnedLabelNames.add(label.toStringWithNamespace());
        }
        return returnedLabelNames;
    }

    private static boolean labelIsVisibleToUser(Namespace namespace, Label label, String username) {
        return "public".equals(namespace.getVisibility()) || "owner".equals(label.getNamespace().getVisibility()) && username != null && username.equals(label.getOwner());
    }

    public static List split(String input) {
        if (StringUtils.isEmpty((String)input)) {
            return Collections.EMPTY_LIST;
        }
        StringTokenizer tokens = new StringTokenizer(input, LABEL_DELIM_CHARS, false);
        LinkedList<String> newLabelNames = new LinkedList<String>();
        while (tokens.hasMoreTokens()) {
            newLabelNames.add(tokens.nextToken().trim());
        }
        return newLabelNames;
    }

    public static int countLabels(String input) {
        if (StringUtils.isEmpty((String)input)) {
            return 0;
        }
        return new StringTokenizer(input, LABEL_DELIM_CHARS, false).countTokens();
    }

    private static Collection filterUserLabels(Collection newLabelNames, String userName) {
        LinkedList<String> filteredNewLabelNames = new LinkedList<String>();
        for (String labelName : newLabelNames) {
            ParsedLabelName r = LabelParser.parse(labelName);
            if (TextUtils.stringSet((String)r.getOwner())) {
                if (!r.getOwner().equals(userName)) continue;
                filteredNewLabelNames.add("my:" + r.getName());
                continue;
            }
            filteredNewLabelNames.add(labelName);
        }
        return filteredNewLabelNames;
    }

    public static boolean syncState(String source, LabelManager labelManager, User user, Labelable dest, boolean removeUnusedLabels) {
        Collection labelNames = LabelUtil.split(source);
        if (!LabelUtil.isValidLabelNames(labelNames)) {
            return false;
        }
        String userName = user != null ? user.getName() : null;
        labelNames = LabelUtil.filterUserLabels(labelNames, userName);
        ListOrderedSet requestedLabels = new ListOrderedSet();
        Iterator it = labelNames.iterator();
        while (it.hasNext()) {
            ParsedLabelName ref = LabelParser.parse((String)it.next());
            requestedLabels.add(ref.toLabel());
        }
        PermittedLabelView labelable = new PermittedLabelView(dest, user, true);
        ListOrderedSet existingLabels = ListOrderedSet.decorate((List)labelable.getLabels());
        Collection labelsToRemove = CollectionUtils.subtract((Collection)existingLabels, (Collection)requestedLabels);
        for (Label label : labelsToRemove) {
            labelManager.removeLabel((ContentEntityObject)dest, label);
            LabelUtil.recordLabelInteractionInHistory(label);
        }
        Collection labelsToAdd = CollectionUtils.subtract((Collection)requestedLabels, (Collection)existingLabels);
        for (Label label : labelsToAdd) {
            labelManager.addLabel((ContentEntityObject)dest, label);
            LabelUtil.recordLabelInteractionInHistory(label);
        }
        return true;
    }

    public static boolean addLabel(String labelReference, LabelManager labelManager, User user, Labelable dest) {
        return LabelUtil.addLabel(labelReference, labelManager, dest) != null;
    }

    public static Label addLabel(String labelReference, LabelManager labelManager, Labelable object) {
        if (!LabelUtil.isValidLabelName(labelReference) || !LabelUtil.isValidLabelLength(labelReference)) {
            return null;
        }
        ParsedLabelName parsedLabelName = LabelParser.parse(labelReference);
        if (parsedLabelName == null) {
            return null;
        }
        Label label = parsedLabelName.toLabel();
        int result = labelManager.addLabel((ContentEntityObject)object, label);
        LabelUtil.recordLabelInteractionInHistory(label);
        if (result == 0) {
            return null;
        }
        if (result == 1) {
            return labelManager.getLabel(label);
        }
        return label;
    }

    public static void recordLabelInteractionInHistory(Label label) {
        Map session = ActionContext.getContext().getSession();
        if (session == null) {
            return;
        }
        UserHistory history = (UserHistory)session.get("confluence.user.history");
        if (history == null) {
            history = new UserHistory(20);
            session.put("confluence.user.history", history);
        }
        history.addLabel(label);
    }

    public static List rankResults(List results) {
        LinkedList<RankedLabelSearchResult> rankedResults = new LinkedList<RankedLabelSearchResult>();
        int currentCount = -1;
        int rank = 0;
        for (int i = 0; i < results.size(); ++i) {
            LabelSearchResult labelSearchResult = (LabelSearchResult)results.get(i);
            if (currentCount != labelSearchResult.getCount()) {
                currentCount = labelSearchResult.getCount();
                rank = i + 1;
            }
            RankedLabelSearchResult info = new RankedLabelSearchResult(labelSearchResult.getLabel(), rank, labelSearchResult.getCount());
            rankedResults.add(info);
        }
        return rankedResults;
    }

    public static List getRecentAndPopularLabelsForEntity(ContentEntityObject entity, LabelManager labelManager, int maxResults, String user) {
        int maxRequiredResults = entity.getLabelCount() + maxResults;
        List recentlyUsedLabels = TextUtils.stringSet((String)user) ? LabelUtil.filterDuplicates(labelManager.getRecentlyUsedPersonalLabels(user, maxRequiredResults)) : new ArrayList();
        List mostPopularLabels = SpaceContentEntityObject.class.isAssignableFrom(entity.getClass()) && TextUtils.stringSet((String)((SpaceContentEntityObject)entity).getSpaceKey()) ? labelManager.getMostPopularLabelsInSpace(((SpaceContentEntityObject)entity).getSpaceKey(), maxRequiredResults) : labelManager.getMostPopularLabels(maxRequiredResults);
        LabelUtil.fixLabels(mostPopularLabels);
        mostPopularLabels = LabelUtil.filterDuplicates(mostPopularLabels);
        recentlyUsedLabels.removeAll(entity.getLabels());
        mostPopularLabels.removeAll(entity.getLabels());
        mostPopularLabels.removeAll(recentlyUsedLabels);
        int halfSuggestedCount = maxResults / 2;
        int recentLabelsUpperBound = Math.min(recentlyUsedLabels.size(), halfSuggestedCount);
        int popularLabelUpperbound = Math.min(mostPopularLabels.size(), halfSuggestedCount);
        if (recentLabelsUpperBound < halfSuggestedCount && mostPopularLabels.size() > halfSuggestedCount) {
            popularLabelUpperbound = Math.min(mostPopularLabels.size(), maxResults - recentLabelsUpperBound);
        } else if (popularLabelUpperbound < halfSuggestedCount && recentlyUsedLabels.size() > halfSuggestedCount) {
            recentLabelsUpperBound = Math.min(recentlyUsedLabels.size(), maxResults - popularLabelUpperbound);
        }
        LinkedList result = new LinkedList();
        result.addAll(recentlyUsedLabels.subList(0, recentLabelsUpperBound));
        result.addAll(mostPopularLabels.subList(0, popularLabelUpperbound));
        return result;
    }

    private static List filterDuplicates(List list) {
        HashSet tempList = new HashSet();
        tempList.addAll(list);
        ArrayList result = new ArrayList();
        result.addAll(tempList);
        return result;
    }

    public static List getRecentAndPopularLabels(String spaceKey, LabelManager labelManager, int maxResults, String user) {
        int halfSuggestedCount = maxResults / 2;
        HashSet tempLabels = new HashSet();
        List mostPopularLabels = new ArrayList();
        if (TextUtils.stringSet((String)spaceKey)) {
            tempLabels.addAll(GeneralUtil.safeSubList(labelManager.getRecentlyUsedLabelsInSpace(spaceKey), halfSuggestedCount));
            mostPopularLabels = labelManager.getMostPopularLabelsInSpace(spaceKey, halfSuggestedCount);
        } else {
            tempLabels.addAll(GeneralUtil.safeSubList(labelManager.getRecentlyUsedLabels(), halfSuggestedCount));
            mostPopularLabels = labelManager.getMostPopularLabels(halfSuggestedCount);
        }
        LabelUtil.fixLabels(mostPopularLabels);
        tempLabels.addAll(mostPopularLabels);
        ArrayList suggestedLabels = new ArrayList();
        suggestedLabels.addAll(tempLabels);
        return suggestedLabels;
    }

    public static void fixLabels(List suggestedLabels) {
        ListIterator<Label> it = suggestedLabels.listIterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof LabelSearchResult)) continue;
            it.set(((LabelSearchResult)o).getLabel());
        }
    }

    public static List extractLabelsFromLabellings(List labellings) {
        LinkedList<Label> labels = new LinkedList<Label>();
        if (labellings != null) {
            Iterator i = labellings.iterator();
            while (i.hasNext()) {
                labels.add(((Labelling)i.next()).getLabel());
            }
        }
        return labels;
    }

    public static ListFilter getLabelFilters(User user, boolean hideSpecialLabels) {
        FilterChain filters = new FilterChain();
        VisibleLabelFilter visibleLabelFilter = user != null ? new VisibleLabelFilter(user.getName()) : new VisibleLabelFilter();
        filters.addFilter((Filter)visibleLabelFilter);
        if (hideSpecialLabels) {
            filters.addFilter((Filter)new SpecialLabelFilter());
        }
        return new ListFilter((Filter)filters);
    }
}

