/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.actions.PageAware;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.actions.SpaceAware;
import com.opensymphony.xwork.Action;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.interceptor.Interceptor;
import org.apache.log4j.Logger;
import org.apache.log4j.MDC;

public class LoggingContextInterceptor
implements Interceptor {
    protected static Logger log = Logger.getLogger(LoggingContextInterceptor.class);

    public void destroy() {
    }

    public void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String intercept(ActionInvocation actionInvocation) throws Exception {
        try {
            this.buildLoggingContext(actionInvocation);
        }
        catch (Exception ex) {
            log.error((Object)"Exception while building logging context", (Throwable)ex);
        }
        try {
            String string = actionInvocation.invoke();
            return string;
        }
        finally {
            this.cleanLoggingContext();
        }
    }

    protected void buildLoggingContext(ActionInvocation actionInvocation) {
        Space space;
        AbstractPage page;
        Action action = actionInvocation.getAction();
        if (action instanceof PageAware && (page = ((PageAware)action).getPage()) != null) {
            MDC.put((String)"page", (Object)page.getIdAsString());
        }
        if (action instanceof SpaceAware && (space = ((SpaceAware)action).getSpace()) != null) {
            MDC.put((String)"space", (Object)Long.toString(space.getId()));
        }
        MDC.put((String)"action", (Object)actionInvocation.getInvocationContext().getName());
    }

    protected void cleanLoggingContext() {
        MDC.remove((String)"action");
        MDC.remove((String)"space");
        MDC.remove((String)"page");
    }
}

