/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util;

import com.mchange.lang.PotentiallySecondary;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import javax.servlet.ServletException;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;
import org.apache.velocity.exception.MethodInvocationException;

public class PatternLayoutWithStackTrace
extends PatternLayout {
    public boolean ignoresThrowable() {
        return false;
    }

    public String format(LoggingEvent loggingEvent) {
        ThrowableInformation throwableInformation = loggingEvent.getThrowableInformation();
        StringBuffer result = new StringBuffer(super.format(loggingEvent));
        this.appendBeforeStackTrace(result, loggingEvent);
        if (throwableInformation != null) {
            Throwable t = throwableInformation.getThrowable();
            PatternLayoutWithStackTrace.appendStackTrace(result, t);
        }
        return result.toString();
    }

    void appendBeforeStackTrace(StringBuffer result, LoggingEvent event) {
    }

    public static void appendStackTrace(StringBuffer buffer, Throwable t) {
        if (t != null) {
            StringWriter writer = new StringWriter();
            PrintWriter stackTrace = new PrintWriter(writer);
            t.printStackTrace(stackTrace);
            while (t != null) {
                if ((t = PatternLayoutWithStackTrace.getNonCauseUnderlying(t)) == null) continue;
                stackTrace.print("caused by:\n");
                t.printStackTrace(stackTrace);
            }
            buffer.append(writer.getBuffer());
        }
    }

    public static Throwable getNonCauseUnderlying(Throwable t) {
        while (t != null && t.getCause() != null) {
            t = t.getCause();
        }
        if (t != null) {
            t = t instanceof InvocationTargetException ? ((InvocationTargetException)t).getTargetException() : (t instanceof MethodInvocationException ? ((MethodInvocationException)t).getWrappedThrowable() : (t instanceof ServletException ? ((ServletException)t).getRootCause() : (t instanceof PotentiallySecondary ? ((PotentiallySecondary)t).getNestedThrowable() : (t instanceof SQLException ? ((SQLException)t).getNextException() : null))));
        }
        return t;
    }
}

