/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util;

import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.core.util.thumbnail.Thumber;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.apache.log4j.Category;

public class ProfilePicture {
    public static final Category log = Category.getInstance(ProfilePicture.class);
    InputStream inputStream;
    String filename;
    public static final String PROFILE_PICS_DIR = "profiles";
    private Image sourceImage;
    public static final Color BACKGROUND_LIGHT_GREY = new Color(240, 240, 240);
    public static final int PICTURE_SIZE = 48;

    public ProfilePicture(InputStream inputStream, String filename) {
        this.inputStream = inputStream;
        this.filename = filename;
        try {
            this.sourceImage = new Thumber().getImage(inputStream);
        }
        catch (IOException e) {
            log.error((Object)"Error creating ProfilePicture whilst loading image stream into a java image object.", (Throwable)e);
        }
    }

    public File create() {
        try {
            int width = this.sourceImage.getWidth(null);
            int height = this.sourceImage.getHeight(null);
            BufferedImage croppedImage = new BufferedImage(48, 48, 1);
            Graphics2D graphics2D = croppedImage.createGraphics();
            HashMap<RenderingHints.Key, Object> hints = new HashMap<RenderingHints.Key, Object>();
            hints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            hints.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
            hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            hints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
            graphics2D.setRenderingHints(hints);
            graphics2D.setColor(BACKGROUND_LIGHT_GREY);
            graphics2D.fillRect(0, 0, 48, 48);
            int whDiff = Math.abs(width - height) / 2;
            int drawTopLeftX = 0;
            int drawTopLeftY = 0;
            int drawBottomRightX = 48;
            int drawBottomRightY = 48;
            if (width < 48) {
                drawTopLeftX = (48 - width) / 2;
                drawBottomRightX = 48 - (48 - width) / 2;
            }
            if (height < 48) {
                drawTopLeftY = (48 - height) / 2;
                drawBottomRightY = 48 - (48 - height) / 2;
            }
            if (width > height) {
                graphics2D.drawImage(this.sourceImage, drawTopLeftX, drawTopLeftY, drawBottomRightX, drawBottomRightY, whDiff, 0, width - whDiff, height, BACKGROUND_LIGHT_GREY, null);
            } else {
                graphics2D.drawImage(this.sourceImage, drawTopLeftX, drawTopLeftY, drawBottomRightX, drawBottomRightY, 0, whDiff, width, height - whDiff, BACKGROUND_LIGHT_GREY, null);
            }
            return this.imageToFile(croppedImage, new File(this.getDirectoryForConvertedProfilePictures(), this.filename));
        }
        catch (HeadlessException e) {
            log.error((Object)"HeadlessException while cropping profile image.  Possibly http://jira.atlassian.com/CONF-7900", (Throwable)e);
            return null;
        }
        catch (Exception e) {
            log.error((Object)"Error cropping image.", (Throwable)e);
            return null;
        }
    }

    private File imageToFile(BufferedImage bufferedImage, File file) {
        try {
            BufferedOutputStream fout = new BufferedOutputStream(new FileOutputStream(file));
            JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)fout);
            JPEGEncodeParam encodeParams = encoder.getDefaultJPEGEncodeParam(bufferedImage);
            encodeParams.setQuality(1.8f, false);
            encoder.setJPEGEncodeParam(encodeParams);
            encoder.encode(bufferedImage);
            ((OutputStream)fout).close();
            return file;
        }
        catch (IOException e) {
            log.error((Object)"Error converting java image to file.", (Throwable)e);
            return null;
        }
    }

    private File getDirectoryForConvertedProfilePictures() {
        File dir = new File(BootstrapUtils.getBootstrapManager().getFilePathProperty("webwork.multipart.saveDir"), PROFILE_PICS_DIR);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }
}

