/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util;

import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.core.util.thumbnail.Thumber;
import com.atlassian.spring.container.ContainerManager;
import java.io.File;
import java.io.InputStream;
import org.apache.log4j.Category;

public class ResizableImage {
    public static final Category log = Category.getInstance(ResizableImage.class);
    File imageToResize;
    InputStream inputStream;
    String filename;
    Thumber thumber;
    public static final String RESIZE_DIR = "resized";

    public ResizableImage(File imageToResize) {
        this.imageToResize = imageToResize;
        this.thumber = (Thumber)ContainerManager.getComponent((String)"thumberTarget");
    }

    public ResizableImage(InputStream inputStream, String filename) {
        this.inputStream = inputStream;
        this.filename = filename;
        this.thumber = (Thumber)ContainerManager.getComponent((String)"thumberTarget");
    }

    public File resizeTo(int height, int width) {
        File resizedImage = null;
        try {
            File directoryForResizedPictures = new File(BootstrapUtils.getBootstrapManager().getFilePathProperty("webwork.multipart.saveDir"), RESIZE_DIR);
            if (!directoryForResizedPictures.exists()) {
                directoryForResizedPictures.mkdirs();
            }
            if (this.imageToResize != null) {
                resizedImage = new File(directoryForResizedPictures, this.imageToResize.getName());
                this.thumber.retrieveOrCreateThumbNail(this.imageToResize, resizedImage, width, height, 0L);
            } else {
                resizedImage = new File(directoryForResizedPictures, this.filename);
                this.thumber.retrieveOrCreateThumbNail(this.inputStream, this.filename, resizedImage, width, height, 0L);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error resizing profile picture.", (Throwable)e);
        }
        return resizedImage;
    }
}

