/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util;

import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.seraph.config.SecurityConfig;
import com.atlassian.seraph.util.RedirectUtils;
import com.opensymphony.util.TextUtils;
import javax.servlet.http.HttpServletRequest;

public class SeraphUtils {
    public static String getLoginURL(HttpServletRequest request) {
        return RedirectUtils.getLoginUrl((HttpServletRequest)request);
    }

    public static String getLinkLoginURL(HttpServletRequest request) {
        String linkLoginURL = RedirectUtils.getLinkLoginURL((HttpServletRequest)request);
        String currentPageUrl = request.getRequestURI() + (TextUtils.stringSet((String)request.getQueryString()) ? "?" + request.getQueryString() : "");
        if (currentPageUrl.startsWith(request.getContextPath())) {
            currentPageUrl = currentPageUrl.substring(request.getContextPath().length());
        }
        if (currentPageUrl.indexOf("/logout.action") >= 0 || currentPageUrl.indexOf("/login.action") >= 0 || currentPageUrl.indexOf("/signup.action") >= 0) {
            return linkLoginURL;
        }
        String destination = currentPageUrl;
        if (currentPageUrl.indexOf("forgotuserpassword.action") >= 0 || currentPageUrl.indexOf("forgotusername.action") >= 0) {
            destination = "/homepage.action";
        }
        linkLoginURL = GeneralUtil.appendAmpsandOrQuestionMark(linkLoginURL);
        linkLoginURL = linkLoginURL + "os_destination=" + GeneralUtil.urlEncode(destination);
        return linkLoginURL;
    }

    public static String getOriginalURL(HttpServletRequest request) {
        String originalURL;
        SecurityConfig config = SeraphUtils.getConfig(request);
        if (config != null && TextUtils.stringSet((String)(originalURL = (String)request.getSession().getAttribute(config.getOriginalURLKey())))) {
            return originalURL;
        }
        return request.getParameter("os_destination");
    }

    public static SecurityConfig getConfig(HttpServletRequest request) {
        return (SecurityConfig)request.getSession().getServletContext().getAttribute("seraph_config");
    }
}

