/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpURL;
import org.apache.commons.httpclient.HttpsURL;
import org.apache.commons.httpclient.URIException;
import org.apache.webdav.lib.Property;
import org.apache.webdav.lib.PropertyName;
import org.apache.webdav.lib.ResponseEntity;
import org.apache.webdav.lib.WebdavResource;
import org.apache.webdav.lib.methods.ReportMethod;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class WebDavUtils {
    private static final DavVersion[] DAV_VERSION_ARRAY = new DavVersion[0];
    private static final String DAV_NAMESPACE = "DAV:";
    private static final String DAV_PREDECESSOR_SET = "predecessor-set";
    private static final String DAV_HREF = "href";
    private static final PropertyName DAV_PREDECESSOR_SET_PROP = new PropertyName("DAV:", "predecessor-set");
    private static final String SCHEME_HTTPS = "https";

    public static List getVersionsOfResource(WebdavResource wdr) throws IOException {
        Vector<PropertyName> queryProps = new Vector<PropertyName>();
        queryProps.add(new PropertyName(DAV_NAMESPACE, DAV_PREDECESSOR_SET));
        HttpURL url = wdr.getHttpURL();
        ReportMethod report = new ReportMethod(url.getURI(), 1, queryProps.elements());
        HttpClient client = wdr.retrieveSessionInstance();
        client.executeMethod((HttpMethod)report);
        LinkedList<DavVersion> davVersions = new LinkedList<DavVersion>();
        Enumeration responses = report.getResponses();
        while (responses.hasMoreElements()) {
            ResponseEntity response = (ResponseEntity)responses.nextElement();
            String href = response.getHref();
            DavVersion version = new DavVersion();
            version.setUrl(href);
            Enumeration responseProperties = report.getResponseProperties(href);
            while (responseProperties.hasMoreElements()) {
                Property property = (Property)responseProperties.nextElement();
                if (!DAV_NAMESPACE.equals(property.getNamespaceURI()) || !DAV_PREDECESSOR_SET.equals(property.getLocalName())) continue;
                Element domElement = property.getElement();
                NodeList predecessorList = domElement.getElementsByTagNameNS(DAV_NAMESPACE, DAV_HREF);
                if (predecessorList.getLength() <= 0) break;
                String predecessor = predecessorList.item(0).getFirstChild().getNodeValue();
                version.setPredecessor(predecessor);
                break;
            }
            davVersions.add(version);
        }
        return WebDavUtils.getPredecessorChain(davVersions.toArray(DAV_VERSION_ARRAY));
    }

    public static HttpURL uriToHttpURL(String uri) throws URIException {
        return uri.startsWith(SCHEME_HTTPS) ? new HttpsURL(uri.toCharArray()) : new HttpURL(uri.toCharArray());
    }

    private static List getPredecessorChain(DavVersion[] versions) {
        DavVersion initialVersion = null;
        HashMap<String, String> predecessorMap = new HashMap<String, String>();
        LinkedList<String> chain = new LinkedList<String>();
        for (int x = 0; x < versions.length; ++x) {
            DavVersion theVersion = versions[x];
            if (theVersion.hasPredecessor()) {
                predecessorMap.put(theVersion.getPredecessor(), theVersion.getUrl());
                continue;
            }
            if (initialVersion == null) {
                initialVersion = theVersion;
                continue;
            }
            throw new IllegalStateException("More than one initial DAV version");
        }
        if (initialVersion == null) {
            throw new IllegalStateException("No initial version found");
        }
        String currentVersion = initialVersion.getUrl();
        while (currentVersion != null) {
            chain.add(currentVersion);
            String nextVersion = (String)predecessorMap.get(currentVersion);
            predecessorMap.remove(currentVersion);
            currentVersion = nextVersion;
        }
        if (!predecessorMap.isEmpty()) {
            throw new IllegalStateException("Possible webDAV predecessor-set sequence break or cycle");
        }
        return chain;
    }

    private static class DavVersion {
        private String url;
        private String predecessor;

        private DavVersion() {
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getPredecessor() {
            return this.predecessor;
        }

        public void setPredecessor(String predecessor) {
            this.predecessor = predecessor;
        }

        public String toString() {
            return "DavVersion: {url: " + this.getUrl() + ", predecessor: " + (this.hasPredecessor() ? this.getPredecessor() : "<none>") + "}";
        }

        public boolean hasPredecessor() {
            return this.predecessor != null;
        }

        public int hashCode() {
            String hashString = this.getUrl() + ":";
            if (this.hasPredecessor()) {
                hashString = hashString + this.getPredecessor();
            }
            return hashString.hashCode();
        }
    }
}

