/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util;

import com.atlassian.core.exception.InfrastructureException;
import com.atlassian.core.util.ClassLoaderUtils;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Category;

public class XslUtil {
    private Category log = Category.getInstance(this.getClass());
    private TransformerFactory transformerFactory = null;
    private Transformer transformer = null;

    public XslUtil(String xslPath) {
        try {
            this.transformerFactory = (TransformerFactory)ClassLoaderUtils.loadClass((String)"com.icl.saxon.TransformerFactoryImpl", this.getClass()).newInstance();
        }
        catch (Exception e) {
            this.log.error((Object)"Can not initialize the XSL Transformer Factory!", (Throwable)e);
            throw new IllegalStateException(e.getMessage());
        }
        StreamSource xslSource = new StreamSource(ClassLoaderUtils.getResourceAsStream((String)xslPath, this.getClass()));
        try {
            this.transformer = this.transformerFactory.newTransformer(xslSource);
            this.transformer.setOutputProperty("encoding", "UTF-8");
        }
        catch (TransformerConfigurationException e) {
            this.log.error((Object)"Can not initialize the XSL Transformer!", (Throwable)e);
            throw new InfrastructureException("Can not initialize the XSL Transformer!", (Throwable)e);
        }
    }

    public Transformer getTransformer() {
        return this.transformer;
    }
}

