/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util.breadcrumbs;

import com.atlassian.confluence.admin.actions.LongRunningTaskMonitorAction;
import com.atlassian.confluence.admin.actions.LookAndFeel;
import com.atlassian.confluence.core.Administrative;
import com.atlassian.confluence.dashboard.actions.DashboardAction;
import com.atlassian.confluence.labels.DisplayableLabel;
import com.atlassian.confluence.mail.Mail;
import com.atlassian.confluence.mail.actions.AbstractMailAction;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.actions.PageNotFoundAction;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.actions.SpaceAdministrative;
import com.atlassian.confluence.themes.GlobalHelper;
import com.atlassian.confluence.user.actions.AbstractGroupAction;
import com.atlassian.confluence.user.actions.AbstractUserProfileAction;
import com.atlassian.confluence.user.actions.AbstractUsersAction;
import com.atlassian.confluence.user.actions.PeopleDirectoryAction;
import com.atlassian.confluence.user.actions.SearchUsersAction;
import com.atlassian.confluence.user.actions.ViewMembersOfGroupAction;
import com.atlassian.confluence.util.breadcrumbs.AdminActionBreadcrumb;
import com.atlassian.confluence.util.breadcrumbs.Breadcrumb;
import com.atlassian.confluence.util.breadcrumbs.BreadcrumbAware;
import com.atlassian.confluence.util.breadcrumbs.ContentActionBreadcrumb;
import com.atlassian.confluence.util.breadcrumbs.DashboardBreadcrumb;
import com.atlassian.confluence.util.breadcrumbs.GroupAdminActionBreadcrumb;
import com.atlassian.confluence.util.breadcrumbs.LongRunningTaskBreadcrumb;
import com.atlassian.confluence.util.breadcrumbs.MailActionBreadcrumb;
import com.atlassian.confluence.util.breadcrumbs.MailServersActionBreadcrumb;
import com.atlassian.confluence.util.breadcrumbs.PageNotFoundBreadcrumb;
import com.atlassian.confluence.util.breadcrumbs.PageTemplatesActionBreadcrumb;
import com.atlassian.confluence.util.breadcrumbs.PeopleBreadcrumb;
import com.atlassian.confluence.util.breadcrumbs.SpaceAdminActionBreadcrumb;
import com.atlassian.confluence.util.breadcrumbs.UserAdminActionBreadcrumb;
import com.atlassian.confluence.util.breadcrumbs.UserProfileActionBreadcrumb;
import com.opensymphony.xwork.Action;
import javax.servlet.http.HttpServletRequest;

public class BreadcrumbGenerator {
    private final GlobalHelper globalHelper;

    public BreadcrumbGenerator(GlobalHelper globalHelper) {
        this.globalHelper = globalHelper;
    }

    public Breadcrumb getBreadcrumb(Action action, HttpServletRequest request) {
        if (action instanceof BreadcrumbAware) {
            return ((BreadcrumbAware)action).getBreadcrumb();
        }
        String urlPath = this.getUrlPath(request);
        if (action instanceof AbstractUsersAction) {
            return new UserAdminActionBreadcrumb(action, ((AbstractUsersAction)action).getUser());
        }
        if (action instanceof SearchUsersAction) {
            return new UserAdminActionBreadcrumb(action, null);
        }
        if (action instanceof Administrative || urlPath.equals("/admin")) {
            if (action instanceof AbstractGroupAction) {
                return new GroupAdminActionBreadcrumb(action, ((AbstractGroupAction)action).getGroup());
            }
            if (action instanceof ViewMembersOfGroupAction) {
                return new GroupAdminActionBreadcrumb(action, null);
            }
            return new AdminActionBreadcrumb(action);
        }
        if (urlPath.equals("/pages/templates")) {
            return new PageTemplatesActionBreadcrumb(action, this.getSpace());
        }
        if (action instanceof DashboardAction) {
            return DashboardBreadcrumb.getInstance();
        }
        if (action instanceof PeopleDirectoryAction) {
            return PeopleBreadcrumb.getInstance();
        }
        if (action instanceof AbstractUserProfileAction) {
            return new UserProfileActionBreadcrumb(action);
        }
        if (this.isInPackage(action, "com.atlassian.confluence.mail.actions")) {
            Mail mail = null;
            if (action instanceof AbstractMailAction) {
                mail = ((AbstractMailAction)action).getMail();
            }
            return new MailActionBreadcrumb(action, this.getSpace(), mail);
        }
        if (this.isInPackage(action, "com.atlassian.confluence.admin.actions.mail")) {
            return new MailServersActionBreadcrumb(action);
        }
        if (this.isInPackage(action, "com.atlassian.confluence.admin")) {
            return new AdminActionBreadcrumb(action);
        }
        if (action instanceof SpaceAdministrative) {
            return new SpaceAdminActionBreadcrumb(action, this.getSpace());
        }
        if (action instanceof LookAndFeel) {
            return new AdminActionBreadcrumb(action);
        }
        if (action instanceof LongRunningTaskMonitorAction) {
            return new LongRunningTaskBreadcrumb(action);
        }
        if (action instanceof PageNotFoundAction) {
            return new PageNotFoundBreadcrumb(action, this.getSpace());
        }
        return new ContentActionBreadcrumb(action, this.getSpace(), this.getPage(), this.getLabel());
    }

    private String getUrlPath(HttpServletRequest request) {
        if (request == null) {
            return "";
        }
        String path = request.getRequestURI();
        path = path.substring(request.getContextPath().length());
        return path.substring(0, path.lastIndexOf(47));
    }

    private boolean isInPackage(Action action, String packagePrefix) {
        return action.getClass().getName().startsWith(packagePrefix);
    }

    private DisplayableLabel getLabel() {
        return this.globalHelper.getLabel();
    }

    public Space getSpace() {
        return this.globalHelper.getSpace();
    }

    public AbstractPage getPage() {
        return this.globalHelper.getPage();
    }
}

