/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util.breadcrumbs;

import com.atlassian.confluence.labels.DisplayableLabel;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.actions.AbstractDiffPagesAction;
import com.atlassian.confluence.pages.actions.AbstractPageAction;
import com.atlassian.confluence.pages.actions.AbstractPageAwareAction;
import com.atlassian.confluence.pages.actions.RevertPageBackToVersionAction;
import com.atlassian.confluence.pages.actions.ViewPageAction;
import com.atlassian.confluence.pages.actions.ViewPreviousVersionsAction;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.actions.AbstractSpaceAction;
import com.atlassian.confluence.spaces.actions.SpaceAware;
import com.atlassian.confluence.util.breadcrumbs.AbstractSpaceActionBreadcrumb;
import com.atlassian.confluence.util.breadcrumbs.BlogPostBreadcrumb;
import com.atlassian.confluence.util.breadcrumbs.Breadcrumb;
import com.atlassian.confluence.util.breadcrumbs.BrowseSpaceBreadcrumb;
import com.atlassian.confluence.util.breadcrumbs.DashboardBreadcrumb;
import com.atlassian.confluence.util.breadcrumbs.LabelBreadcrumb;
import com.atlassian.confluence.util.breadcrumbs.PageBreadcrumb;
import com.atlassian.confluence.util.breadcrumbs.SimpleBreadcrumb;
import com.atlassian.confluence.util.breadcrumbs.SpaceBreadcrumb;
import com.opensymphony.xwork.Action;
import java.util.ArrayList;
import java.util.List;

public class ContentActionBreadcrumb
extends AbstractSpaceActionBreadcrumb {
    private AbstractPage page;
    private DisplayableLabel label;

    public ContentActionBreadcrumb(Action action, Space space, AbstractPage page, DisplayableLabel label) {
        super(action, space);
        this.page = page;
        this.label = label;
    }

    protected List getMyCrumbs() {
        ArrayList<Breadcrumb> breadcrumbs = new ArrayList<Breadcrumb>();
        if (this.label == null) {
            Breadcrumb parentActionBreadcrumb = this.getPreviousActionBreadcrumb();
            if (parentActionBreadcrumb != null) {
                breadcrumbs.add(parentActionBreadcrumb);
            }
            if (!(this.action instanceof ViewPageAction)) {
                breadcrumbs.add(this);
            }
        }
        return breadcrumbs;
    }

    public Breadcrumb getParent() {
        if (this.label != null) {
            return new LabelBreadcrumb(this.action, this.label, this.space);
        }
        if (this.page != null) {
            if (this.page instanceof Page) {
                return new PageBreadcrumb((Page)this.page);
            }
            if (this.page instanceof BlogPost) {
                return new BlogPostBreadcrumb((BlogPost)this.page);
            }
        } else if (this.space != null) {
            return new SpaceBreadcrumb(this.space);
        }
        return DashboardBreadcrumb.getInstance();
    }

    private Breadcrumb getPreviousActionBreadcrumb() {
        if (this.space != null && (this.action instanceof AbstractSpaceAction || this.action instanceof SpaceAware)) {
            return new BrowseSpaceBreadcrumb(this.space);
        }
        if (this.action instanceof RevertPageBackToVersionAction) {
            AbstractPageAction abstractPageAction = (AbstractPageAction)this.action;
            this.page = abstractPageAction.getPage();
            return new SimpleBreadcrumb("information.name", "/pages/viewinfo.action?pageId=" + this.page.getIdAsString());
        }
        if (this.action instanceof ViewPreviousVersionsAction || this.action instanceof AbstractDiffPagesAction) {
            AbstractPageAwareAction abstractPageAction = (AbstractPageAwareAction)this.action;
            this.page = abstractPageAction.getPage();
            return new SimpleBreadcrumb("information.name", "/pages/viewinfo.action?pageId=" + this.page.getIdAsString());
        }
        return null;
    }
}

