/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util.breadcrumbs;

import com.atlassian.confluence.mail.Mail;
import com.atlassian.confluence.mail.actions.ViewMailAction;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.util.breadcrumbs.AbstractBreadcrumb;
import com.atlassian.confluence.util.breadcrumbs.AbstractSpaceBreadcrumb;
import com.atlassian.confluence.util.breadcrumbs.Breadcrumb;
import com.atlassian.confluence.util.breadcrumbs.BrowseSpaceBreadcrumb;
import com.atlassian.confluence.util.breadcrumbs.SimpleBreadcrumb;
import com.opensymphony.xwork.Action;
import java.util.ArrayList;
import java.util.List;

public class MailActionBreadcrumb
extends AbstractSpaceBreadcrumb {
    private Mail mail;
    private Action action;

    public MailActionBreadcrumb(Action action, Space space, Mail mail) {
        super(space);
        this.mail = mail;
        this.action = action;
    }

    protected List getMyCrumbs() {
        ArrayList<SimpleBreadcrumb> crumbs = new ArrayList<SimpleBreadcrumb>();
        if (this.mail != null) {
            ViewMailAction viewMailAction;
            if (this.action instanceof ViewMailAction && (viewMailAction = (ViewMailAction)this.action).isInThread()) {
                crumbs.add(new SimpleBreadcrumb("mail.thread", "/spaces/viewthread.action?key=" + this.space.getKey() + "&id=" + this.mail.getId()));
            }
            crumbs.add(new SimpleBreadcrumb(this.mail.getTitle(), this.mail.getUrlPath()));
        }
        return crumbs;
    }

    protected Breadcrumb getParent() {
        return new MailArchiveBreadcrumb();
    }

    private class MailArchiveBreadcrumb
    extends AbstractBreadcrumb {
        public MailArchiveBreadcrumb() {
            super("mail.archive", "/spaces/viewmailarchive.action?key=" + MailActionBreadcrumb.this.space.getKey());
        }

        protected Breadcrumb getParent() {
            return new BrowseSpaceBreadcrumb(MailActionBreadcrumb.this.space);
        }
    }
}

