/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util.classpath;

import com.atlassian.confluence.util.ClasspathUtils;
import com.atlassian.confluence.util.classpath.ClasspathClasses;
import com.atlassian.confluence.util.classpath.ClasspathJarSets;
import com.atlassian.confluence.util.classpath.DuplicateClassFinder;
import com.atlassian.confluence.util.classpath.JarSet;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.PredicateUtils;

public class ClasspathJarDuplicateClassFinder
implements DuplicateClassFinder {
    public static final List<String> KNOWN_DUPLICATES = Arrays.asList("org/w3c/", "javax/xml/", "org/xml/sax/", "org/apache/xalan/", "org/apache/xml/", "org/apache/xpath/", "org/apache/xmlcommons", "org.jaxen", "org/aopalliance/aop/", "org/aopalliance/intercept/", "alt/javax/", "alt/java/", "com/mockobjects/", "javax/media/jai", "com/sun/media/jai", "http/utils/multipartrequest/", "org/apache/velocity/", "org/apache/commons/collections/", "org/apache/oro/", "bsh/OfbizBshBsfEngine.class", "org/ofbiz/core/", "org/apache/poi/", "electric/util/", "electric/xml/", "org/apache/jasper/compiler/", "org/apache/commons/logging/", "org/apache/naming/", "org/apache/html/", "org/apache/wml/", "org/apache/xerces/", "org/apache/catalina/loader", "org/apache/catalina/security", "org/apache/catalina/startup", "org/apache", "org/apache/catalina/util", "com/atlassian/confluence/compatibility/cache/spring", "org/apache/log");
    public static final Predicate EXCLUDE_KNOWN_DUPLICATES = new Predicate(){

        public boolean evaluate(Object object) {
            if (!(object instanceof String)) {
                return false;
            }
            String classFileName = (String)object;
            return !ClasspathJarDuplicateClassFinder.isKnownDuplicate(classFileName);
        }
    };
    private ClasspathJarSets classpathJarSets;
    private final Predicate classFileNamePredicate;

    public ClasspathJarDuplicateClassFinder() {
        this(PredicateUtils.truePredicate());
    }

    public ClasspathJarDuplicateClassFinder(Predicate classFileNamePredicate) {
        this.classFileNamePredicate = classFileNamePredicate;
    }

    public Set getJarSetsWithCommonClasses() {
        return this.getClasspathJarSets().getJarSetsWithCommonClasses();
    }

    private synchronized ClasspathJarSets getClasspathJarSets() {
        if (this.classpathJarSets == null) {
            ClasspathClasses classpathClasses = ClasspathUtils.getClassesInClasspathJars();
            this.classpathJarSets = new ClasspathJarSets(classpathClasses, this.classFileNamePredicate);
        }
        return this.classpathJarSets;
    }

    public SortedSet getClassFileNames(JarSet jars) {
        return this.getClasspathJarSets().getClassFileNames(jars);
    }

    public SortedSet getPackageNames(JarSet jars) {
        return this.getClasspathJarSets().getPackageNames(jars);
    }

    public static boolean isKnownDuplicate(String classFileName) {
        for (String packageName : KNOWN_DUPLICATES) {
            if (!classFileName.startsWith(packageName)) continue;
            return true;
        }
        return false;
    }
}

