/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util.classpath;

import com.atlassian.confluence.util.classpath.ClasspathClasses;
import com.atlassian.confluence.util.classpath.DuplicateClassFinder;
import com.atlassian.confluence.util.classpath.JarSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.PredicateUtils;
import org.apache.commons.collections.Transformer;

public class ClasspathJarSets
implements DuplicateClassFinder {
    private final Map classesByJarSet = new HashMap();

    public ClasspathJarSets() {
    }

    public ClasspathJarSets(ClasspathClasses classpathClasses) {
        this(classpathClasses, PredicateUtils.truePredicate());
    }

    public ClasspathJarSets(ClasspathClasses classpathClasses, Predicate classFileNamePredicate) {
        Iterator<String> iterator = classpathClasses.iterator();
        while (iterator.hasNext()) {
            String classFileName = iterator.next();
            if (!classFileNamePredicate.evaluate((Object)classFileName)) continue;
            this.addClass(classFileName, classpathClasses.getJarsForClass(classFileName));
        }
    }

    public void addClass(String classFileName, JarSet jars) {
        if (!this.classesByJarSet.containsKey(jars)) {
            this.classesByJarSet.put(jars, new HashSet());
        }
        ((Set)this.classesByJarSet.get(jars)).add(classFileName);
    }

    public Set getJarSetsWithCommonClasses() {
        HashSet jarSets = new HashSet(this.classesByJarSet.keySet());
        CollectionUtils.filter(jarSets, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                if (!(object instanceof JarSet)) {
                    return false;
                }
                return ((JarSet)object).size() > 1;
            }
        });
        return Collections.unmodifiableSet(jarSets);
    }

    public SortedSet getClassFileNames(JarSet jars) {
        if (!this.classesByJarSet.containsKey(jars)) {
            return new TreeSet();
        }
        return new TreeSet((Set)this.classesByJarSet.get(jars));
    }

    public SortedSet getPackageNames(JarSet jars) {
        SortedSet result = this.getClassFileNames(jars);
        CollectionUtils.transform((Collection)result, (Transformer)new Transformer(){

            public Object transform(Object classFileName) {
                return ClasspathJarSets.this.getPackageName((String)classFileName);
            }
        });
        return result;
    }

    private String getPackageName(String classFileName) {
        int index = classFileName.lastIndexOf("/");
        if (index == -1) {
            return "";
        }
        return classFileName.substring(0, index);
    }
}

