/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util.http.httpclient;

import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.http.BaseHttpRetrievalService;
import com.atlassian.confluence.util.http.ConfluenceHttpParameters;
import com.atlassian.confluence.util.http.HttpRequest;
import com.atlassian.confluence.util.http.HttpResponse;
import com.atlassian.confluence.util.http.httpclient.HttpClientAuthenticator;
import com.atlassian.confluence.util.http.httpclient.HttpClientHttpResponse;
import com.opensymphony.util.TextUtils;
import com.opensymphony.webwork.ServletActionContext;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpRecoverableException;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Category;

public class HttpClientHttpRetrievalService
extends BaseHttpRetrievalService {
    public static final Category log = Category.getInstance(HttpClientHttpRetrievalService.class);

    public HttpResponse get(HttpRequest httpRequest) throws IOException {
        ConfluenceHttpParameters httpParameters;
        HttpClient client = new HttpClient();
        URL remoteUrl = new URL(httpRequest.getUrl());
        String host = System.getProperty("http.proxyHost");
        if (host != null && !this.isNonProxyHost(remoteUrl.getHost())) {
            int port = 80;
            try {
                port = Integer.parseInt(System.getProperty("http.proxyPort", "80"));
            }
            catch (NumberFormatException e) {
                log.warn((Object)"System property 'http.proxyPort' is not a number. Defaulting to 80.");
            }
            client.getHostConfiguration().setProxy(host, port);
            if (this.authenticationRequired()) {
                client.getState().setProxyCredentials(new AuthScope(host, port), (Credentials)new UsernamePasswordCredentials(System.getProperty("http.proxyUser"), System.getProperty("http.proxyPassword")));
            }
        }
        if (!(httpParameters = this.getConnectionParameters()).isEnabled()) {
            throw new IOException("External connections have been disabled");
        }
        this.setTimeouts(client, httpParameters);
        String url = httpRequest.getUrl();
        HttpMethod method = this.makeMethod(httpRequest, client, url);
        int includeStackDepth = this.calculateIncludeStackDepth();
        method.addRequestHeader("X-Confluence-HTTP-Stack-Depth", Integer.toString(includeStackDepth));
        method.setRequestHeader("User-agent", MessageFormat.format("Confluence/{0} (http://www.atlassian.com/software/confluence)", GeneralUtil.getVersionNumber()));
        int statusCode = -1;
        for (int attempt = 0; statusCode == -1 && attempt < 3; ++attempt) {
            try {
                if (httpRequest.getAuthenticator() != null) {
                    ((HttpClientAuthenticator)httpRequest.getAuthenticator()).preprocess(client, method);
                }
                if ((statusCode = client.executeMethod(method)) < 300 || statusCode > 399) continue;
                Header locationHeader = method.getResponseHeader("location");
                if (locationHeader != null) {
                    String redirectLocation = locationHeader.getValue();
                    method = this.makeMethod(httpRequest, client, redirectLocation);
                    statusCode = -1;
                    continue;
                }
                throw new IOException("URL returned an error. Status code: " + statusCode);
            }
            catch (HttpRecoverableException e) {
                log.info((Object)("A recoverable exception occurred, retrying." + e.getMessage()), (Throwable)e);
                continue;
            }
            catch (IOException e) {
                log.info((Object)("Failed to download " + httpRequest.getUrl()), (Throwable)e);
                throw new IOException("Could not download: " + httpRequest.getUrl() + " - " + e.toString());
            }
        }
        if (statusCode == -1) {
            log.info((Object)"Failed to recover from exception.");
            throw new IOException("Failed to recover from an exception: " + httpRequest.getUrl());
        }
        return new HttpClientHttpResponse(httpRequest, method);
    }

    private void setTimeouts(HttpClient client, ConfluenceHttpParameters connectionParameters) {
        ConfluenceHttpParameters parameters = connectionParameters;
        HttpConnectionManagerParams params = client.getHttpConnectionManager().getParams();
        params.setSoTimeout(parameters.getSocketTimeout());
        params.setConnectionTimeout(parameters.getConnectionTimeout());
    }

    private boolean authenticationRequired() {
        return System.getProperty("http.proxyUser") != null;
    }

    private boolean isNonProxyHost(String host) {
        String httpNonProxyHosts = System.getProperty("http.nonProxyHosts");
        if (StringUtils.isBlank((String)httpNonProxyHosts)) {
            if (StringUtils.isBlank((String)System.getProperty("http.nonProxyHost"))) {
                log.warn((Object)"The system property http.nonProxyHost is set. You probably meant to set http.nonProxyHosts.");
            }
            return false;
        }
        String[] nonProxyHosts = httpNonProxyHosts.split("\\|");
        for (int i = 0; i < nonProxyHosts.length; ++i) {
            if (!(nonProxyHosts[i].startsWith("*") ? host.endsWith(nonProxyHosts[i].substring(1)) : host.equals(nonProxyHosts[i]))) continue;
            return true;
        }
        return false;
    }

    private HttpMethod makeMethod(HttpRequest httpRequest, HttpClient client, String url) {
        if (httpRequest.getAuthenticator() != null) {
            return ((HttpClientAuthenticator)httpRequest.getAuthenticator()).makeMethod(client, url);
        }
        return new GetMethod(url);
    }

    private int calculateIncludeStackDepth() throws IOException {
        int includeStackDepth = 1;
        HttpServletRequest request = ServletActionContext.getRequest();
        if (request != null) {
            int existingDepth = TextUtils.parseInt((String)request.getHeader("X-Confluence-HTTP-Stack-Depth"));
            if (existingDepth >= 1) {
                throw new IOException("HTTP include stack depth of more than 1!");
            }
            if (existingDepth > 0) {
                includeStackDepth = existingDepth + 1;
            }
        }
        return includeStackDepth;
    }

    public Class[] getAvailableAuthenticators() {
        return new Class[0];
    }
}

