/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util.i18n;

import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.util.i18n.CombinedResourceBundle;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.i18n.I18NResourceBundlesLoader;
import com.atlassian.confluence.util.i18n.LanguagePluginI18NResource;
import com.atlassian.confluence.util.i18n.Message;
import com.atlassian.confluence.util.i18n.PluginI18NResource;
import com.atlassian.confluence.util.i18n.ResourceBundlesCollector;
import com.atlassian.confluence.velocity.htmlsafe.HtmlSafe;
import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.elements.ResourceDescriptor;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;

public class DefaultI18NBean
implements I18NBean {
    public static final Logger log = Logger.getLogger(I18NBean.class);
    private static final String HIGHLIGHT = "confluence.i18n.highlight";
    private static final String SHOWKEY = "confluence.i18n.showkey";
    private static boolean HIGHLIGHT_FLAG = false;
    private static boolean SHOWKEY_FLAG = false;
    private List bundles = new ArrayList();
    private Locale locale;
    private PluginAccessor pluginAccessor;

    public DefaultI18NBean(Locale locale, PluginAccessor pluginManager) {
        this.locale = locale;
        this.pluginAccessor = pluginManager;
        if ("true".equalsIgnoreCase((String)BootstrapUtils.getBootstrapManager().getProperty("hibernate.setup")) && pluginManager != null) {
            ResourceBundlesCollector bundlesCollector = new ResourceBundlesCollector();
            this.loadDefaultBundle(bundlesCollector);
            this.loadLanguagePluginBundles(bundlesCollector, locale);
            this.loadPluginI18NResources(bundlesCollector, locale);
            this.bundles.addAll(bundlesCollector.getCombinedResourceBundles());
        } else {
            ResourceBundle bundle = locale != null && !locale.equals(LocaleManager.DEFAULT_LOCALE) ? this.getLocaleSpecificResourceBundle(locale) : this.getDefaultResourceBundle();
            if (bundle != null) {
                this.bundles.add(bundle);
            }
        }
    }

    private void loadDefaultBundle(ResourceBundlesCollector bundlesCollector) {
        bundlesCollector.addBundle(this.getDefaultResourceBundle());
    }

    private void loadLanguagePluginBundles(ResourceBundlesCollector bundlesCollector, Locale locale) {
        LanguagePluginI18NResource languagePluginI18NResource = new LanguagePluginI18NResource(this.pluginAccessor);
        Map bundles = I18NResourceBundlesLoader.getResourceBundles(languagePluginI18NResource, locale);
        bundlesCollector.addBundles(bundles);
    }

    private void loadPluginI18NResources(ResourceBundlesCollector bundlesCollector, Locale locale) {
        ArrayList<ResourceDescriptor> i18nResourceDescriptors = new ArrayList<ResourceDescriptor>();
        for (Plugin plugin : this.pluginAccessor.getEnabledPlugins()) {
            try {
                for (ResourceDescriptor resourceDescriptor : plugin.getResourceDescriptors("i18n")) {
                    i18nResourceDescriptors.add(resourceDescriptor);
                }
                for (ModuleDescriptor moduleDescriptor : plugin.getModuleDescriptors()) {
                    for (ResourceDescriptor resourceDescriptor : moduleDescriptor.getResourceDescriptors("i18n")) {
                        i18nResourceDescriptors.add(resourceDescriptor);
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)("Unable to load i18n resources for: " + plugin.getName() + "(" + plugin.getKey() + ") " + e.toString()), (Throwable)e);
            }
        }
        for (ResourceDescriptor resourceDescriptor : i18nResourceDescriptors) {
            PluginI18NResource i18nPluginI18NResource = new PluginI18NResource(resourceDescriptor, this.pluginAccessor);
            Map resouceBundles = I18NResourceBundlesLoader.getResourceBundles(i18nPluginI18NResource, locale);
            bundlesCollector.addBundles(resouceBundles);
        }
    }

    @HtmlSafe
    public String getText(String key) {
        if (key == null) {
            return "";
        }
        return this.addNecessaryMarkup(key, this.getI18nValue(key));
    }

    @HtmlSafe
    public String getText(String key, Object[] args) {
        String result = this.getText(key);
        if (result == null) {
            return result;
        }
        try {
            return MessageFormat.format(result, args);
        }
        catch (IllegalArgumentException ex) {
            log.error((Object)("Error formatting internationalized string with key: " + key));
            return key;
        }
    }

    @HtmlSafe
    public String getText(String key, List list) {
        if (list != null) {
            return this.getText(key, list.toArray());
        }
        return this.getText(key, new Object[0]);
    }

    @HtmlSafe
    public String getText(Message message) {
        return this.getText(message.getKey(), message.getArguments());
    }

    public String getTextStrict(String i18nKey) {
        return this.getI18nValue(i18nKey);
    }

    public ResourceBundle getResourceBundle() {
        for (ResourceBundle bundle : this.bundles) {
            if (bundle == null) continue;
            return bundle;
        }
        return this.getDefaultResourceBundle();
    }

    private String addNecessaryMarkup(String i18nKey, String i18nValue) {
        String prefix = (this.isI18nHighlightMode() ? "<span class=replaced>[" : "") + (this.isShowKeyMode() ? i18nKey + ":" : "");
        String postfix = this.isI18nHighlightMode() ? "]</span>" : "";
        return prefix + i18nValue + postfix;
    }

    private String getI18nValue(String i18nKey) {
        for (ResourceBundle bundle : this.bundles) {
            try {
                if (i18nKey.startsWith("'") && i18nKey.endsWith("'")) {
                    i18nKey = i18nKey.substring(1, i18nKey.length() - 1);
                }
                try {
                    return bundle.getString(i18nKey);
                }
                catch (MissingResourceException mre) {
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Error getting text for key: (" + i18nKey + ") against resource bundle: (" + bundle + ") for locale: (" + this.locale + ")"), (Throwable)e);
            }
        }
        log.debug((Object)("Error getting text for key: (" + i18nKey + ")"));
        return i18nKey;
    }

    private ResourceBundle getDefaultResourceBundle() {
        PropertyResourceBundle coreBundle;
        String defaultI18nPropertiesPath = ConfluenceActionSupport.class.getName().replace('.', '/') + ".properties";
        try {
            coreBundle = new PropertyResourceBundle(ClassLoaderUtils.getResourceAsStream((String)defaultI18nPropertiesPath, this.getClass()));
        }
        catch (IOException e) {
            log.error((Object)("Error occurred reading the stream for " + defaultI18nPropertiesPath + "."), (Throwable)e);
            return null;
        }
        ResourceBundle externalLinksBundle = this.getExternalLinksBundle();
        ArrayList<ResourceBundle> defaultBundles = new ArrayList<ResourceBundle>();
        defaultBundles.add(coreBundle);
        if (externalLinksBundle != null) {
            defaultBundles.add(externalLinksBundle);
        }
        return new CombinedResourceBundle(defaultBundles);
    }

    private ResourceBundle getLocaleSpecificResourceBundle(Locale locale) {
        ResourceBundle coreBundle = ClassLoaderUtils.getBundle((String)DEFAULT_RESOURCE_BUNDLE, (Locale)locale, this.getClass());
        ResourceBundle externalLinksBundle = this.getExternalLinksBundle();
        ArrayList<ResourceBundle> defaultBundles = new ArrayList<ResourceBundle>();
        defaultBundles.add(coreBundle);
        if (externalLinksBundle != null) {
            defaultBundles.add(externalLinksBundle);
        }
        return new CombinedResourceBundle(defaultBundles);
    }

    private ResourceBundle getExternalLinksBundle() {
        try {
            return new PropertyResourceBundle(ClassLoaderUtils.getResourceAsStream((String)"external-links.properties", this.getClass()));
        }
        catch (IOException e) {
            log.error((Object)"Error occurred reading the stream for external-links.properties.", (Throwable)e);
            return null;
        }
    }

    public boolean isI18nHighlightMode() {
        return HIGHLIGHT_FLAG;
    }

    public boolean isShowKeyMode() {
        return SHOWKEY_FLAG;
    }

    static {
        HIGHLIGHT_FLAG = Boolean.getBoolean(HIGHLIGHT);
        SHOWKEY_FLAG = Boolean.getBoolean(SHOWKEY);
    }
}

