/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util.profiling;

import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.setup.webwork.ConfluenceVelocityContext;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.confluence.velocity.context.ConfluenceContextUtils;
import com.atlassian.confluence.velocity.htmlsafe.HtmlFragment;
import com.atlassian.confluence.velocity.htmlsafe.HtmlSafe;
import com.atlassian.util.profiling.UtilTimerStack;
import com.opensymphony.module.sitemesh.Config;
import com.opensymphony.module.sitemesh.Decorator;
import com.opensymphony.module.sitemesh.Factory;
import com.opensymphony.module.sitemesh.HTMLPage;
import com.opensymphony.module.sitemesh.Page;
import com.opensymphony.module.sitemesh.filter.PageFilter;
import com.opensymphony.module.sitemesh.util.OutputConverter;
import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.webwork.views.velocity.VelocityManager;
import com.opensymphony.xwork.ActionContext;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.velocity.context.Context;

public class ProfilingPageFilter
extends PageFilter {
    private static final Logger log = Logger.getLogger(ProfilingPageFilter.class);
    private static Factory smFactory;

    public void init(FilterConfig filterConfig) {
        super.init(filterConfig);
        smFactory = Factory.getInstance((Config)new Config(filterConfig));
    }

    public static Factory getFactory() {
        return smFactory;
    }

    public static void setupFactory(ServletConfig servletConfig) {
        smFactory = Factory.getInstance((Config)new Config(servletConfig));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyDecorator(Page page, Decorator decorator, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpServletRequest originalRequest = ServletActionContext.getRequest();
        HttpServletResponse originalResponse = ServletActionContext.getResponse();
        UtilTimerStack.push((String)this.makeApplyDecoratorStackMessage(decorator));
        try {
            ServletActionContext.setRequest((HttpServletRequest)request);
            ServletActionContext.setResponse((HttpServletResponse)response);
            if (request.getParameter("sitemeshDispatcher") == null) {
                log.debug((Object)"Using Confluence Velocity decoration");
                this.applyDecoratorUsingVelocity(request, page, response, decorator);
            } else {
                log.debug((Object)"Using default SiteMesh decoration");
                super.applyDecorator(page, decorator, request, response);
            }
        }
        finally {
            UtilTimerStack.pop((String)this.makeApplyDecoratorStackMessage(decorator));
            ServletActionContext.setRequest((HttpServletRequest)originalRequest);
            ServletActionContext.setResponse((HttpServletResponse)originalResponse);
        }
    }

    private void applyDecoratorUsingVelocity(HttpServletRequest request, Page page, HttpServletResponse response, Decorator decorator) throws IOException {
        request.setAttribute("__sitemesh__page", (Object)page);
        Context context = VelocityManager.getInstance().createContext(ActionContext.getContext().getValueStack(), request, response);
        ConfluenceVelocityContext cvctx = new ConfluenceVelocityContext();
        for (String key : cvctx.getConfluenceKeys().keySet()) {
            context.put(key, cvctx.get(key));
        }
        if (BootstrapUtils.getBootstrapManager().isSetupComplete()) {
            ConfluenceContextUtils.modifyRequestContext(context, request);
        }
        ConfluenceActionSupport action = (ConfluenceActionSupport)MacroUtils.getConfluenceActionSupport();
        context.put("action", (Object)action);
        context.put("helper", (Object)action.getHelper());
        context.put("sitemeshPage", (Object)page);
        context.put("title", (Object)page.getTitle());
        StringWriter bodyBuffer = new StringWriter();
        page.writeBody(OutputConverter.getWriter((Writer)bodyBuffer));
        context.put("body", (Object)bodyBuffer);
        if (page instanceof HTMLPage) {
            HTMLPage htmlPage = (HTMLPage)page;
            StringWriter buffer = new StringWriter();
            htmlPage.writeHead(OutputConverter.getWriter((Writer)buffer));
            context.put("head", (Object)new HtmlFragment(buffer.toString()));
            context.put("sitemeshPage", (Object)new VelocitySitemeshPage((HTMLPage)page));
            context.put("body", (Object)new HtmlFragment(bodyBuffer));
            context.put("title", (Object)new HtmlFragment(page.getTitle()));
            ConfluenceContextUtils.processContextForHtmlRendering(context);
        }
        response.getWriter().write(VelocityUtils.getRenderedTemplate(decorator.getPage(), context));
        while (decorator.getInitParameterNames().hasNext()) {
            String initParam = (String)decorator.getInitParameterNames().next();
            if (!initParam.startsWith("header.")) continue;
            response.setHeader(initParam.substring(initParam.indexOf(46)), decorator.getInitParameter(initParam));
        }
        request.removeAttribute("__sitemesh__page");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Page parsePage(HttpServletRequest request, HttpServletResponse httpServletResponse, FilterChain filterChain) throws IOException, ServletException {
        UtilTimerStack.push((String)this.makeParsePageStackMessage(request));
        try {
            Page page = super.parsePage(request, httpServletResponse, filterChain);
            return page;
        }
        finally {
            UtilTimerStack.pop((String)this.makeParsePageStackMessage(request));
        }
    }

    private String makeApplyDecoratorStackMessage(Decorator decorator) {
        return "SiteMesh: applyDecorator: " + decorator.getName() + " (" + decorator.getPage() + ")";
    }

    private String makeParsePageStackMessage(HttpServletRequest request) {
        return "SiteMesh: parsePage: " + request.getRequestURL();
    }

    public static void ensureFactorySetup(ServletConfig servletConfig) {
        if (ProfilingPageFilter.getFactory() == null) {
            ProfilingPageFilter.setupFactory(servletConfig);
        }
    }

    public static class VelocitySitemeshPage
    implements HTMLPage {
        private final HTMLPage delegatePage;

        public VelocitySitemeshPage(HTMLPage delegatePage) {
            this.delegatePage = delegatePage;
        }

        public void writePage(Writer writer) throws IOException {
            this.delegatePage.writePage(writer);
        }

        public String getPage() {
            return this.delegatePage.getPage();
        }

        public void writeBody(Writer writer) throws IOException {
            this.delegatePage.writeBody(writer);
        }

        public String getBody() {
            return this.delegatePage.getBody();
        }

        public String getTitle() {
            return this.delegatePage.getTitle();
        }

        public int getContentLength() {
            return this.delegatePage.getContentLength();
        }

        @HtmlSafe
        public String getProperty(String s) {
            return this.delegatePage.getProperty(s);
        }

        public int getIntProperty(String s) {
            return this.delegatePage.getIntProperty(s);
        }

        public long getLongProperty(String s) {
            return this.delegatePage.getLongProperty(s);
        }

        public boolean getBooleanProperty(String s) {
            return this.delegatePage.getBooleanProperty(s);
        }

        public boolean isPropertySet(String s) {
            return this.delegatePage.isPropertySet(s);
        }

        public String[] getPropertyKeys() {
            return this.delegatePage.getPropertyKeys();
        }

        public Map getProperties() {
            return this.delegatePage.getProperties();
        }

        public HttpServletRequest getRequest() {
            return this.delegatePage.getRequest();
        }

        public void setRequest(HttpServletRequest httpServletRequest) {
            this.delegatePage.setRequest(httpServletRequest);
        }

        public void addProperty(String s, String s1) {
            this.delegatePage.addProperty(s, s1);
        }

        public void writeHead(Writer writer) throws IOException {
            this.delegatePage.writeHead(writer);
        }

        public String getHead() {
            return this.delegatePage.getHead();
        }

        public boolean isFrameSet() {
            return this.delegatePage.isFrameSet();
        }

        public void setFrameSet(boolean b) {
            this.delegatePage.setFrameSet(b);
        }
    }
}

