/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util.velocity;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheFactory;
import java.io.Serializable;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Category;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.ResourceCache;

public class ConfluenceVelocityResourceCache
implements ResourceCache {
    public static final Category log = Category.getInstance(ConfluenceVelocityResourceCache.class);
    private static final String RESOURCE_CACHE_NAME = "com.atlassian.confluence.util.velocity.ConfluenceVelocityResourceCache";
    private static ConfluenceVelocityResourceCache instance;
    private RuntimeServices runtimeServices;
    private Cache cache;

    public ConfluenceVelocityResourceCache(CacheFactory cacheFactory) {
        this.cache = cacheFactory.getCache(RESOURCE_CACHE_NAME);
        instance = this;
    }

    public static ConfluenceVelocityResourceCache getInstance() {
        return instance;
    }

    public static void clearAllCaches() {
        if (instance == null) {
            return;
        }
        instance.clear();
    }

    public static void removeFromCaches(Object key) {
        log.info((Object)("removing " + key + " from caches"));
        if (instance == null) {
            return;
        }
        ConfluenceVelocityResourceCache cache = instance;
        cache.remove(key);
        String searchKey = key.toString();
        if (searchKey.startsWith("/")) {
            searchKey = searchKey.substring(1);
        }
        Iterator keyIterator = cache.enumerateKeys();
        while (keyIterator.hasNext()) {
            String cachedKey = (String)keyIterator.next();
            if (!StringUtils.contains((String)cachedKey, (String)searchKey)) continue;
            cache.remove(cachedKey);
        }
    }

    public void initialize(RuntimeServices runtimeServices) {
        this.runtimeServices = runtimeServices;
        runtimeServices.debug((Object)"Initialising Confluence Velocity Cache");
    }

    public Resource get(Object key) {
        this.runtimeServices.getLog().debug((Object)("Getting " + key + " from cache"));
        return this.getResource(key);
    }

    public Resource put(Object key, Resource resource) {
        this.runtimeServices.debug((Object)("Adding " + key + " to cache"));
        this.cache.put(key, (Object)new FakeSerializableResource(resource));
        return resource;
    }

    public Resource remove(Object key) {
        this.runtimeServices.debug((Object)("Removing " + key + " from cache"));
        try {
            Resource resource = this.getResource(key);
            this.cache.remove(key);
            return resource;
        }
        catch (Exception e) {
            log.error((Object)("Error removing cache key '" + key + "'"), (Throwable)e);
            return null;
        }
    }

    public Iterator enumerateKeys() {
        return this.cache.getKeys().iterator();
    }

    public void clear() {
        try {
            this.cache.removeAll();
        }
        catch (Exception e) {
            log.error((Object)"Error clearing resource cache", (Throwable)e);
        }
    }

    private Resource getResource(Object key) {
        if ("true".equalsIgnoreCase(System.getProperty("atlassian.disable.caches"))) {
            return null;
        }
        FakeSerializableResource holder = (FakeSerializableResource)this.cache.get(key);
        if (holder == null) {
            return null;
        }
        Resource resource = holder.get();
        if (resource == null) {
            log.warn((Object)"A FakeSerializableResource has been serialized");
            this.remove(key);
        }
        return resource;
    }

    private static class FakeSerializableResource
    implements Serializable {
        private transient Resource ref = null;

        public FakeSerializableResource(Resource object) {
            this.ref = object;
        }

        public Resource get() {
            return this.ref;
        }
    }
}

