/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util.velocity;

import com.atlassian.cache.CacheFactory;
import com.atlassian.confluence.setup.velocity.DecoratorName;
import com.atlassian.confluence.util.velocity.ConfigurableResourceManager;
import com.atlassian.confluence.util.velocity.ConfluenceVelocityResourceCache;
import com.atlassian.confluence.util.velocity.HtmlContentSniffingTemplate;
import com.atlassian.confluence.util.velocity.ResourceLoaderWrapper;
import java.io.InputStream;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.log4j.Category;
import org.apache.velocity.Template;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.resource.ContentResource;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;

public class ConfluenceVelocityResourceManager
extends ConfigurableResourceManager {
    protected static final Category log = Category.getInstance(ConfluenceVelocityResourceManager.class);
    private static ConfluenceVelocityResourceManager instance;
    private static final ConfigurableResourceManager.ResourceFactory RESOURCE_FACTORY;
    private static CacheFactory cacheFactory;

    public ConfluenceVelocityResourceManager() {
        instance = this;
    }

    public static void setCacheFactory(CacheFactory cacheFactory) {
        ConfluenceVelocityResourceManager.cacheFactory = cacheFactory;
        if (instance != null) {
            instance.initConfluenceVelocityCache();
        }
    }

    public void initialize(RuntimeServices runtimeServices) throws Exception {
        super.initialize(runtimeServices);
        this.initConfluenceVelocityCache();
    }

    static void bootstrapConfluenceVelocityCache() {
        instance.initConfluenceVelocityCache();
    }

    private synchronized void initConfluenceVelocityCache() {
        if (cacheFactory == null) {
            log.debug((Object)"No cache manager. Using default resource cache");
            return;
        }
        log.debug((Object)"Initializing ConfluenceVelocityResourceCache");
        this.globalCache = new ConfluenceVelocityResourceCache(cacheFactory);
        this.globalCache.initialize(this.rsvc);
    }

    protected ResourceLoader postProcessLoader(ResourceLoader loader, ExtendedProperties config) {
        if (!config.getBoolean("confluence.space.decorator.loader", false)) {
            loader = new DecoratorFilteredResourceLoader(loader);
        }
        return super.postProcessLoader(loader, config);
    }

    protected ConfigurableResourceManager.ResourceFactory getResourceFactory() {
        return RESOURCE_FACTORY;
    }

    public static boolean isHtmlTemplate(Template template) {
        if (template.getName().contains("html/")) {
            return true;
        }
        if (template instanceof HtmlContentSniffingTemplate) {
            return ((HtmlContentSniffingTemplate)template).isHtmlTemplate();
        }
        return false;
    }

    static {
        RESOURCE_FACTORY = new ConfluenceResourceFactory();
    }

    public static class ConfluenceResourceFactory
    implements ConfigurableResourceManager.ResourceFactory {
        public Resource getResource(String resourceName, int resourceType) {
            HtmlContentSniffingTemplate resource = null;
            switch (resourceType) {
                case 1: {
                    resource = new HtmlContentSniffingTemplate();
                    break;
                }
                case 2: {
                    resource = new ContentResource();
                }
            }
            return resource;
        }
    }

    private static class DecoratorFilteredResourceLoader
    extends ResourceLoaderWrapper {
        public DecoratorFilteredResourceLoader(ResourceLoader loader) {
            super(loader);
        }

        public final InputStream getResourceStream(String s) throws ResourceNotFoundException {
            if (DecoratorName.isSpaceDecoratorSource(s)) {
                return null;
            }
            return super.getResourceStream(s);
        }
    }
}

