/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util.velocity;

import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.velocity.context.ConfluenceContextUtils;
import com.atlassian.core.exception.InfrastructureException;
import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.spring.container.ContainerManager;
import com.opensymphony.webwork.views.velocity.VelocityManager;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Category;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class VelocityUtils {
    private static Category log = Category.getInstance(VelocityUtils.class);

    public static String getRenderedTemplate(String templateName, Map contextMap) {
        return VelocityUtils.getRenderedTemplate(templateName, (Context)new VelocityContext(contextMap));
    }

    public static String getRenderedTemplate(String templateName, Context context) {
        try {
            return VelocityUtils.getRenderedTemplateWithoutSwallowingErrors(templateName, context);
        }
        catch (Exception e) {
            log.error((Object)("Error occurred rendering template: " + templateName), (Throwable)e);
            return "";
        }
    }

    public static String getRenderedTemplateWithoutSwallowingErrors(String templateName, Map contextMap) throws Exception {
        return VelocityUtils.getRenderedTemplateWithoutSwallowingErrors(templateName, (Context)new VelocityContext(contextMap));
    }

    public static String getRenderedTemplateWithoutSwallowingErrors(String templateName, Context context) throws Exception {
        Template template = VelocityUtils.getTemplate(templateName);
        ConfluenceContextUtils.processContextForTemplate(template, context);
        StringWriter writer = VelocityUtils.getStringWriterForTemplate(template);
        template.merge(context, (Writer)writer);
        return writer.toString();
    }

    private static StringWriter getStringWriterForTemplate(Template template) {
        return template.getData() instanceof String ? new StringWriter(template.getData().toString().length()) : new StringWriter(512);
    }

    public static Template getTemplate(String templateName) throws Exception {
        String encoding;
        if (!BootstrapUtils.getBootstrapManager().isSetupComplete()) {
            encoding = "UTF-8";
        } else {
            SettingsManager settingsManager = (SettingsManager)ContainerManager.getComponent((String)"settingsManager");
            encoding = settingsManager.getGlobalSettings().getDefaultEncoding();
        }
        return VelocityUtils.getVelocityEngine().getTemplate(templateName, encoding);
    }

    public static VelocityEngine getVelocityEngine() throws Exception {
        VelocityEngine velocityEngine = VelocityManager.getInstance().getVelocityEngine();
        if (velocityEngine == null) {
            log.error((Object)"Initialising another velocity engine - should never happen in normal usage - warning!");
            velocityEngine = new VelocityEngine();
            Properties props = new Properties();
            props.load(ClassLoaderUtils.getResourceAsStream((String)"velocity.properties", VelocityUtils.class));
            velocityEngine.init(props);
        }
        return velocityEngine;
    }

    public static String getRenderedContent(String templateContent, Map contextMap) {
        try {
            VelocityContext context = new VelocityContext(contextMap);
            StringWriter tempWriter = new StringWriter(templateContent.length());
            VelocityUtils.getVelocityEngine().evaluate((Context)context, (Writer)tempWriter, "getRenderedContent", templateContent);
            return tempWriter.toString();
        }
        catch (Exception e) {
            log.error((Object)"Error occurred rendering template content", (Throwable)e);
            throw new InfrastructureException("Error occurred rendering template content", (Throwable)e);
        }
    }
}

