/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util.zip;

import com.atlassian.confluence.util.zip.StreamUnzipper;
import com.atlassian.confluence.util.zip.Unzipper;
import com.opensymphony.util.TextUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.zip.ZipEntry;
import org.apache.log4j.Category;

public class FileUnzipper
implements Unzipper {
    private static final Category log = Category.getInstance(FileUnzipper.class);
    private File zipFile;
    private File destDir;

    public FileUnzipper(File zipFile, File destDir) {
        this.zipFile = zipFile;
        this.destDir = destDir;
    }

    public void unzip() throws IOException {
        if (this.zipFile == null || !this.zipFile.isFile()) {
            return;
        }
        this.getStreamUnzipper().unzip();
    }

    public ZipEntry[] entries() throws IOException {
        return this.getStreamUnzipper().entries();
    }

    public File unzipFileInArchive(String fileName) throws IOException {
        File result = null;
        if (this.zipFile == null || !this.zipFile.isFile() || !TextUtils.stringSet((String)fileName)) {
            return result;
        }
        result = this.getStreamUnzipper().unzipFileInArchive(fileName);
        if (result == null) {
            log.error((Object)("The file: " + fileName + " could not be found in the archive: " + this.zipFile.getAbsolutePath()));
        }
        return result;
    }

    private StreamUnzipper getStreamUnzipper() throws FileNotFoundException {
        return new StreamUnzipper(new BufferedInputStream(new FileInputStream(this.zipFile)), this.destDir);
    }
}

