/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.velocity.introspection;

import com.atlassian.confluence.velocity.annotations.CollectionInheritable;
import com.atlassian.confluence.velocity.introspection.AnnotationBoxedElement;
import com.atlassian.confluence.velocity.introspection.AnnotationValidationUtils;
import com.atlassian.confluence.velocity.introspection.BoxedValue;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnnotatedValue
implements AnnotationBoxedElement {
    private final Object value;
    private final Collection<Annotation> annotations;

    public AnnotatedValue(Object value, Collection<Annotation> annotations) {
        Assert.isTrue((!(value instanceof BoxedValue) ? 1 : 0) != 0, (String)"Attempting to box an already boxed value");
        Assert.notNull(annotations, (String)"annotations must not be null");
        AnnotationValidationUtils.assertContainsNoNulls(annotations, "Null annotations are not permitted");
        this.value = value;
        this.annotations = new HashSet<Annotation>(annotations);
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> aClass) {
        for (Annotation annotation : this.annotations) {
            if (!annotation.annotationType().equals(aClass)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> tClass) {
        for (Annotation annotation : this.annotations) {
            if (!annotation.annotationType().equals(tClass)) continue;
            return (T)annotation;
        }
        return null;
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.annotations.toArray(new Annotation[this.annotations.size()]);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.getAnnotations();
    }

    public Object unbox() {
        return this.value;
    }

    @Override
    public Object box(Object value) {
        return new AnnotatedValue(value, this.annotations);
    }

    public Collection<Annotation> getCollectionInheritableAnnotations() {
        HashSet<Annotation> inheritableAnnotations = new HashSet<Annotation>();
        for (Annotation annotation : this.getAnnotations()) {
            if (!annotation.annotationType().isAnnotationPresent(CollectionInheritable.class)) continue;
            inheritableAnnotations.add(annotation);
        }
        return Collections.unmodifiableCollection(inheritableAnnotations);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnnotatedValue that = (AnnotatedValue)o;
        if (!((Object)this.annotations).equals(that.annotations)) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public int hashCode() {
        int result = this.value != null ? this.value.hashCode() : 0;
        result = 31 * result + ((Object)this.annotations).hashCode();
        return result;
    }

    public final String getDescription() {
        return "Annotated value: " + this.value.toString() + "; Annotations: " + this.annotations;
    }

    public String toString() {
        return this.value.toString();
    }
}

