/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.velocity.introspection;

import com.atlassian.confluence.velocity.introspection.AnnotatedValue;
import com.atlassian.confluence.velocity.introspection.AnnotationBoxedElement;
import com.atlassian.confluence.velocity.introspection.AnnotationValidationUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AnnotationPreservingInvocationHandler
implements InvocationHandler {
    private final Collection<Annotation> annotations;
    private final Object targetObject;
    private final Set<Method> preservingMethods;

    private AnnotationPreservingInvocationHandler(Collection<Annotation> annotations, Object targetObject, Set<Method> proxiedMethods) {
        Assert.notNull(annotations, (String)"annotations must not be null");
        AnnotationValidationUtils.assertContainsNoNulls(annotations, "annotations must not contain nulls");
        Assert.notNull((Object)targetObject, (String)"targetObject must not be null");
        Assert.notEmpty(proxiedMethods, (String)"proxiedMethods must not be empty");
        this.annotations = new HashSet<Annotation>(annotations);
        this.targetObject = targetObject;
        this.preservingMethods = proxiedMethods;
    }

    public AnnotationPreservingInvocationHandler(AnnotationBoxedElement value, Set<Method> preservingMethods) {
        this(Arrays.asList(value.getAnnotations()), value.unbox(), preservingMethods);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object returnValue = method.invoke(this.targetObject, args);
        if (this.preservingMethods.contains(method)) {
            return new AnnotatedValue(returnValue, this.annotations);
        }
        return returnValue;
    }
}

