/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.velocity.introspection;

import com.atlassian.confluence.velocity.introspection.InterfaceMethods;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class InterfaceMethodsSet {
    private final Set<InterfaceMethods> interfaceMethodsSet;

    InterfaceMethodsSet() {
        this.interfaceMethodsSet = Collections.emptySet();
    }

    InterfaceMethodsSet(Set<InterfaceMethods> interfaceMethodsSet) {
        Assert.notNull(interfaceMethodsSet);
        this.interfaceMethodsSet = Collections.unmodifiableSet(new HashSet<InterfaceMethods>(interfaceMethodsSet));
    }

    public Set<Class> getInterfaces() {
        HashSet<Class> interfaceSet = new HashSet<Class>();
        for (InterfaceMethods interfaceMethods : this.interfaceMethodsSet) {
            interfaceSet.add(interfaceMethods.getDeclaringInterface());
        }
        return interfaceSet;
    }

    public Set<Method> getMethods() {
        HashSet<Method> methodSet = new HashSet<Method>();
        for (InterfaceMethods interfaceMethods : this.interfaceMethodsSet) {
            methodSet.addAll(interfaceMethods.getMethods());
        }
        return methodSet;
    }

    public boolean isEmpty() {
        return this.interfaceMethodsSet.isEmpty();
    }

    public InterfaceMethodsSet getImplementedMethods(Class clazz) {
        HashSet<InterfaceMethods> implementedMethods = new HashSet<InterfaceMethods>(this.interfaceMethodsSet);
        Iterator iterator = implementedMethods.iterator();
        while (iterator.hasNext()) {
            if (((InterfaceMethods)iterator.next()).isImplementation(clazz)) continue;
            iterator.remove();
        }
        return new InterfaceMethodsSet(implementedMethods);
    }
}

