/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import com.atlassian.bonnie.LuceneUtils;
import com.atlassian.bonnie.search.FilterCountingSearcher;
import com.atlassian.confluence.search.lucene.filter.FiltersContainer;
import java.io.IOException;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Category;
import org.apache.lucene.search.DelayCloseIndexSearcher;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.FieldSortedHitQueue;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.HitQueue;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.Weight;
import org.apache.lucene.store.Directory;

public class DateFilterScoringSearcher
extends DelayCloseIndexSearcher
implements FilterCountingSearcher {
    static Category log = Category.getInstance(DateFilterScoringSearcher.class);
    private static ThreadLocal filteredCounter = new ThreadLocal();
    private static final float BOOST_TODAY = 1.5f;
    private static final float BOOST_YESTERDAY = 1.3f;
    private static final float BOOST_WEEK_AGO = 1.25f;
    private static final float BOOST_MONTH_AGO = 1.2f;
    private boolean boostByAge = true;

    public DateFilterScoringSearcher(Directory directory) throws IOException {
        super(directory);
    }

    public void resetFilteredCounts() {
        int[] counts = (int[])filteredCounter.get();
        if (counts != null) {
            for (int i = 0; i < counts.length; ++i) {
                counts[i] = 0;
            }
        }
    }

    public void search(Weight weight, Filter filter, final HitCollector results) throws IOException {
        Scorer scorer;
        HitCollector collector = results;
        if (filter != null) {
            final BitSet[] bitSets = this.getBitSets(filter);
            collector = new HitCollector(){

                public final void collect(int doc, float score) {
                    if (DateFilterScoringSearcher.this.passesFilters(doc, bitSets)) {
                        results.collect(doc, score);
                    }
                }
            };
        }
        if ((scorer = weight.scorer(this.reader)) == null) {
            return;
        }
        scorer.score(collector);
    }

    private BitSet[] getBitSets(Filter filter) throws IOException {
        List<Object> filters = filter == null ? Collections.EMPTY_LIST : (filter instanceof FiltersContainer ? ((FiltersContainer)filter).getFilters() : Arrays.asList(filter));
        BitSet[] bitSets = new BitSet[filters.size()];
        for (int i = 0; i < filters.size(); ++i) {
            Filter subFilter = filters.get(i);
            bitSets[i] = subFilter.bits(this.reader);
        }
        filteredCounter.set(new int[filters.size()]);
        return bitSets;
    }

    private boolean passesFilters(int doc, BitSet[] bitSets) {
        boolean passes = true;
        for (int i = 0; i < bitSets.length; ++i) {
            if (bitSets[i].get(doc)) continue;
            int[] nArray = this.getFilteredCounts();
            int n = i;
            nArray[n] = nArray[n] + 1;
            passes = false;
            break;
        }
        return passes;
    }

    public TopDocs search(Query query, Filter filter, final int nDocs) throws IOException {
        if (nDocs <= 0) {
            throw new IllegalArgumentException("nDocs must be > 0");
        }
        final String[] fieldcache = FieldCache.DEFAULT.getStrings(this.reader, "modified");
        Scorer scorer = query.weight((Searcher)this).scorer(this.reader);
        if (scorer == null) {
            return new TopDocs(0, new ScoreDoc[0], 0.0f);
        }
        final BitSet[] bitSets = this.getBitSets(filter);
        final HitQueue hq = new HitQueue(nDocs);
        final int[] totalHits = new int[1];
        scorer.score(new HitCollector(){
            private float minScore = 0.0f;

            public final void collect(int doc, float score) {
                if (score > 0.0f && DateFilterScoringSearcher.this.passesFilters(doc, bitSets)) {
                    totalHits[0] = totalHits[0] + 1;
                    Date age = LuceneUtils.stringToDate((String)fieldcache[doc]);
                    score *= DateFilterScoringSearcher.this.getAgeBoostFactor(age);
                    if (hq.size() < nDocs || score >= this.minScore) {
                        hq.insert((Object)new ScoreDoc(doc, score));
                        this.minScore = ((ScoreDoc)hq.top()).score;
                    }
                }
            }
        });
        float topScore = 0.0f;
        ScoreDoc[] scoreDocs = new ScoreDoc[hq.size()];
        for (int i = hq.size() - 1; i >= 0; --i) {
            scoreDocs[i] = (ScoreDoc)hq.pop();
            if (!(scoreDocs[i].score > topScore)) continue;
            topScore = scoreDocs[i].score;
        }
        return new TopDocs(totalHits[0], scoreDocs, topScore);
    }

    public TopFieldDocs search(Query query, Filter filter, int nDocs, Sort sort) throws IOException {
        final String[] fieldcache = FieldCache.DEFAULT.getStrings(this.reader, "modified");
        Scorer scorer = query.weight((Searcher)this).scorer(this.reader);
        if (scorer == null) {
            return new TopFieldDocs(0, new ScoreDoc[0], sort.fields, 0.0f);
        }
        final BitSet[] bitSets = this.getBitSets(filter);
        final FieldSortedHitQueue hq = new FieldSortedHitQueue(this.reader, sort.fields, nDocs);
        final int[] totalHits = new int[1];
        scorer.score(new HitCollector(){

            public final void collect(int doc, float score) {
                if (score > 0.0f && DateFilterScoringSearcher.this.passesFilters(doc, bitSets)) {
                    totalHits[0] = totalHits[0] + 1;
                    Date age = LuceneUtils.stringToDate((String)fieldcache[doc]);
                    hq.insert(new FieldDoc(doc, score *= DateFilterScoringSearcher.this.getAgeBoostFactor(age)));
                }
            }
        });
        ScoreDoc[] scoreDocs = new ScoreDoc[hq.size()];
        float topScore = 0.0f;
        for (int i = hq.size() - 1; i >= 0; --i) {
            scoreDocs[i] = hq.fillFields((FieldDoc)hq.pop());
            if (!(topScore < scoreDocs[i].score)) continue;
            topScore = scoreDocs[i].score;
        }
        return new TopFieldDocs(totalHits[0], scoreDocs, hq.getFields(), topScore);
    }

    public void search(Query query, Filter filter, final HitCollector results) throws IOException {
        Scorer scorer;
        HitCollector collector = results;
        final String[] fieldcache = FieldCache.DEFAULT.getStrings(this.reader, "modified");
        if (filter != null) {
            final BitSet[] bitSets = this.getBitSets(filter);
            collector = new HitCollector(){

                public final void collect(int doc, float score) {
                    if (DateFilterScoringSearcher.this.passesFilters(doc, bitSets)) {
                        Date age = LuceneUtils.stringToDate((String)fieldcache[doc]);
                        results.collect(doc, score *= DateFilterScoringSearcher.this.getAgeBoostFactor(age));
                    }
                }
            };
        }
        if ((scorer = query.weight((Searcher)this).scorer(this.reader)) == null) {
            return;
        }
        scorer.score(collector);
    }

    public int[] getFilteredCounts() {
        return (int[])filteredCounter.get();
    }

    public Explanation explain(Query query, int doc) throws IOException {
        Explanation e = super.explain(query, doc);
        String[] fieldcache = FieldCache.DEFAULT.getStrings(this.reader, "modified");
        Date docAge = LuceneUtils.stringToDate((String)fieldcache[doc]);
        float ageBoostFactor = this.getAgeBoostFactor(docAge);
        String age = "";
        if (ageBoostFactor == 1.5f) {
            age = "today";
        }
        if (ageBoostFactor == 1.3f) {
            age = "yesterday";
        }
        if (ageBoostFactor == 1.25f) {
            age = "week";
        }
        if (ageBoostFactor == 1.2f) {
            age = "month";
        }
        if (ageBoostFactor == 1.0f) {
            age = ">30 days";
        }
        e.addDetail(new Explanation(ageBoostFactor, "age (" + age + ")"));
        e.setValue(e.getValue() * ageBoostFactor);
        return e;
    }

    private float getAgeBoostFactor(Date date) {
        if (!this.boostByAge) {
            return 1.0f;
        }
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date startOfToday = cal.getTime();
        cal.add(6, -1);
        Date startOfYesterday = cal.getTime();
        cal.add(6, -6);
        Date startOfWeekAgo = cal.getTime();
        cal.add(6, -23);
        Date startOfMonthAgo = cal.getTime();
        float boostFactor = date.after(startOfToday) ? 1.5f : (date.after(startOfYesterday) ? 1.3f : (date.after(startOfWeekAgo) ? 1.25f : (date.after(startOfMonthAgo) ? 1.2f : 1.0f)));
        return boostFactor;
    }

    public void setBoostByAge(boolean boostByAge) {
        this.boostByAge = boostByAge;
    }
}

