/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate.support;

import com.atlassian.confluence.util.io.IOUtils;
import com.atlassian.core.spool.SmartSpool;
import com.atlassian.core.spool.Spool;
import java.io.IOException;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.sf.hibernate.HibernateException;
import org.apache.commons.io.input.CountingInputStream;
import org.apache.log4j.Category;
import org.springframework.jdbc.support.lob.LobCreator;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.orm.hibernate.support.BlobInputStreamType;

public class SpoolingBlobInputStreamType
extends BlobInputStreamType {
    private static final Category log = Category.getInstance(SpoolingBlobInputStreamType.class);
    private Spool spool = SpoolingBlobInputStreamType.getDefaultSpool();

    private static Spool getDefaultSpool() {
        SmartSpool defaultSpool = new SmartSpool();
        defaultSpool.setThresholdBytes(131072);
        return defaultSpool;
    }

    public void setSpool(Spool spool) {
        this.spool = spool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object nullSafeGetInternal(ResultSet rs, int index, LobHandler lobHandler) throws SQLException, IOException, HibernateException {
        InputStream inputStream;
        InputStream is = null;
        try {
            is = (InputStream)super.nullSafeGetInternal(rs, index, lobHandler);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Spooling data for blob get");
            }
            inputStream = this.spool.spool(is);
        }
        catch (Throwable throwable) {
            IOUtils.close(is);
            throw throwable;
        }
        IOUtils.close(is);
        return inputStream;
    }

    protected void nullSafeSetInternal(PreparedStatement ps, int index, Object value, LobCreator lobCreator) throws SQLException, IOException, HibernateException {
        if (value == null) {
            lobCreator.setBlobAsBinaryStream(ps, index, null, 0);
            return;
        }
        InputStream is = (InputStream)value;
        CountingInputStream countingStream = new CountingInputStream(is);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Spooling data for blob set");
        }
        InputStream spooledStream = this.spool.spool((InputStream)countingStream);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Spooled " + countingStream.getCount() + " bytes"));
        }
        lobCreator.setBlobAsBinaryStream(ps, index, spooledStream, countingStream.getCount());
    }
}

