/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.datasource;

import java.sql.Connection;
import java.sql.SQLException;
import org.springframework.jdbc.datasource.DelegatingDataSource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class UserCredentialsDataSourceAdapter
extends DelegatingDataSource {
    private String username;
    private String password;
    private final ThreadLocal threadBoundCredentials = new ThreadLocal();

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setCredentialsForCurrentThread(String username, String password) {
        this.threadBoundCredentials.set(new String[]{username, password});
    }

    public void removeCredentialsFromCurrentThread() {
        this.threadBoundCredentials.set(null);
    }

    public Connection getConnection() throws SQLException {
        String[] threadCredentials = (String[])this.threadBoundCredentials.get();
        if (threadCredentials != null) {
            return this.doGetConnection(threadCredentials[0], threadCredentials[1]);
        }
        return this.doGetConnection(this.username, this.password);
    }

    public Connection getConnection(String username, String password) throws SQLException {
        return this.doGetConnection(username, password);
    }

    protected Connection doGetConnection(String username, String password) throws SQLException {
        Assert.state((this.getTargetDataSource() != null ? 1 : 0) != 0, (String)"'targetDataSource' is required");
        if (StringUtils.hasLength((String)username)) {
            return this.getTargetDataSource().getConnection(username, password);
        }
        return this.getTargetDataSource().getConnection();
    }
}

