/*
 * Decompiled with CFR 0.152.
 */
package electric.application.web.services;

import electric.application.DeploymentException;
import electric.application.web.WebApplication;
import electric.application.web.managed.ObjectManager;
import electric.application.web.services.ManagedService;
import electric.application.web.services.PriorityComparator;
import electric.application.web.services.ServiceEntry;
import electric.application.web.services.ServiceMonitor;
import electric.glue.IGLUELoggingConstants;
import electric.glue.std.config.IConfigConstants;
import electric.service.descriptor.ServiceDescriptor;
import electric.util.array.ArrayUtil;
import electric.util.fileloader.IFileEntry;
import electric.util.io.Streams;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.mime.MIMEData;
import electric.util.path.PathUtil;
import electric.util.sorting.BubbleSort;
import electric.util.string.Strings;
import electric.xml.Document;
import electric.xml.Elements;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;

public final class ServiceManager
extends ObjectManager
implements IGLUELoggingConstants,
IConfigConstants {
    private ServiceMonitor serviceMonitor;

    public ServiceManager(WebApplication application) {
        super(application);
        if (application.isHotDeployable()) {
            this.serviceMonitor = new ServiceMonitor(this, application.getServicesRoot());
        }
    }

    public String getObjectType() {
        return "services";
    }

    public void start() throws Exception {
        this.loadServicesFromDescriptors();
        if (this.serviceMonitor != null) {
            this.serviceMonitor.start();
        }
        super.start();
    }

    public void stop() throws Exception {
        if (this.serviceMonitor != null) {
            this.serviceMonitor.stop();
        }
        super.stop();
    }

    private void loadServicesFromDescriptors() {
        Hashtable pathToEntry = new Hashtable();
        this.addServiceEntriesFromConfig(pathToEntry);
        this.addServiceEntriesFromDirectory(this.application.getServicesRoot(), pathToEntry);
        ServiceEntry[] serviceEntries = this.getServiceEntries(pathToEntry);
        this.sortServiceEntries(serviceEntries);
        this.publishServiceEntries(serviceEntries);
    }

    private void publishServiceEntries(ServiceEntry[] serviceEntries) {
        int i = 0;
        while (i < serviceEntries.length) {
            String publishPath = serviceEntries[i].getPath();
            ServiceDescriptor descriptor = serviceEntries[i].getDescriptor();
            ManagedService service = new ManagedService(this, descriptor, publishPath);
            this.add(publishPath, service);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private ServiceEntry[] getServiceEntries(Hashtable pathToEntry) {
        ServiceEntry[] serviceEntries = new ServiceEntry[]{};
        Enumeration enumeration = pathToEntry.keys();
        while (enumeration.hasMoreElements()) {
            String publishPath = (String)enumeration.nextElement();
            IFileEntry entry = (IFileEntry)pathToEntry.get(publishPath);
            InputStream input = null;
            input = entry.openStream();
            Document document = new Document(Streams.readFully(input));
            ServiceDescriptor descriptor = new ServiceDescriptor(document);
            ServiceEntry serviceEntry = new ServiceEntry(publishPath, descriptor);
            serviceEntries = (ServiceEntry[])ArrayUtil.addElement(serviceEntries, serviceEntry);
            Object var11_11 = null;
            if (input == null) continue;
            try {
                input.close();
            }
            catch (Exception exception2) {}
            continue;
            {
                catch (Exception exception) {
                    if (Log.isLogging(ILoggingConstants.ERROR_EVENT)) {
                        Log.log(ILoggingConstants.ERROR_EVENT, this.getAppName() + ": could not read descriptor " + entry.getAbsolutePath(), exception);
                    }
                    var11_11 = null;
                    if (input == null) continue;
                    try {
                        input.close();
                    }
                    catch (Exception exception2) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                var11_11 = null;
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return serviceEntries;
    }

    private void addServiceEntriesFromDirectory(String path, Hashtable pathToEntry) {
        try {
            IFileEntry[] entries = this.application.getFileLoader().getEntries(path);
            int i = 0;
            while (i < entries.length) {
                IFileEntry entry = entries[i];
                if (entry.isDirectory()) {
                    this.addServiceEntriesFromDirectory(entry.getAbsolutePath(), pathToEntry);
                } else if (entry.getName().toLowerCase().endsWith(".xml")) {
                    pathToEntry.put(this.getPublishPath(entry.getAbsolutePath()), entry);
                }
                ++i;
            }
        }
        catch (Exception exception) {
            if (Log.isLogging(ILoggingConstants.ERROR_EVENT)) {
                Log.log(ILoggingConstants.ERROR_EVENT, this.getAppName() + " could not get descriptors from " + path, exception);
            }
            return;
        }
    }

    private void addServiceEntriesFromConfig(Hashtable pathToEntry) {
        if (!this.application.getConfig().hasElement("serviceDescriptors")) {
            return;
        }
        Elements descriptors = this.application.getConfig().getElement("serviceDescriptors").getElements("path");
        while (descriptors.hasMoreElements()) {
            String path = descriptors.next().getString();
            if (!path.endsWith(".xml")) continue;
            String descriptorPath = this.application.getServicesRoot() + path;
            try {
                IFileEntry entry = this.application.getFileLoader().getEntry(descriptorPath);
                pathToEntry.put(this.getPublishPath(entry.getAbsolutePath()), entry);
            }
            catch (IOException exception) {
                if (!Log.isLogging(ILoggingConstants.ERROR_EVENT)) continue;
                Log.log(ILoggingConstants.ERROR_EVENT, (Object)(this.getAppName() + " unable to locate file " + path));
            }
        }
    }

    private void sortServiceEntries(ServiceEntry[] serviceEntries) {
        BubbleSort.sort(serviceEntries, new PriorityComparator());
    }

    public void addService(String path, ServiceDescriptor descriptor) throws DeploymentException {
        if (descriptor == null) {
            throw new DeploymentException(this.getAppName() + ": could not add service " + path + " due to null descriptor");
        }
        try {
            String descriptorPath = this.getDescriptorPath(path);
            File descriptorFile = new File(descriptorPath);
            if (descriptorFile.exists()) {
                descriptor = this.replaceDescriptor(descriptorFile, descriptor);
            } else {
                new File(descriptorFile.getParent()).mkdirs();
            }
            descriptor.getDocument().write(descriptorFile);
        }
        catch (Exception exception) {
            String message = this.getAppName() + ": could not add service " + path;
            if (Log.isLogging(ILoggingConstants.ERROR_EVENT)) {
                Log.log(ILoggingConstants.ERROR_EVENT, message, exception);
            }
            throw new DeploymentException(message + ": " + exception);
        }
        if (Log.isLogging(IGLUELoggingConstants.DEPLOY_EVENT)) {
            Log.log(IGLUELoggingConstants.DEPLOY_EVENT, (Object)(this.getAppName() + ": added service " + path));
        }
        if (this.serviceMonitor != null) {
            this.serviceMonitor.cycle();
        }
    }

    private ServiceDescriptor replaceDescriptor(File file, ServiceDescriptor descriptor) throws DeploymentException {
        ServiceDescriptor oldDescriptor = this.getDescriptor(file);
        file.delete();
        try {
            if (descriptor.instantiator.getReturnType().equals(oldDescriptor.instantiator.getReturnType())) {
                oldDescriptor.activation = descriptor.activation;
                oldDescriptor.description = descriptor.description;
                oldDescriptor.publish = descriptor.publish;
                return oldDescriptor;
            }
        }
        catch (ClassNotFoundException exception) {}
        return descriptor;
    }

    private ServiceDescriptor getDescriptor(File file) throws DeploymentException {
        try {
            return new ServiceDescriptor(new Document(file));
        }
        catch (Exception exception) {
            String message = this.getAppName() + ": could not parse descriptor " + file.getAbsolutePath();
            if (Log.isLogging(ILoggingConstants.ERROR_EVENT)) {
                Log.log(ILoggingConstants.ERROR_EVENT, message, exception);
            }
            throw new DeploymentException(message + ": " + exception);
        }
    }

    public void addService(String path, MIMEData descriptor) throws DeploymentException {
        try {
            String descriptorPath = this.getDescriptorPath(path);
            File descriptorFile = new File(descriptorPath);
            new File(descriptorFile.getParent()).mkdirs();
            FileOutputStream output = new FileOutputStream(descriptorFile);
            Streams.copy(descriptor.getInputStream(), (OutputStream)output, descriptor.getContentLength(), 10240);
            descriptor.dispose();
            output.close();
        }
        catch (Exception exception) {
            String message = this.getAppName() + ": could not add service " + path;
            if (Log.isLogging(ILoggingConstants.ERROR_EVENT)) {
                Log.log(ILoggingConstants.ERROR_EVENT, message, exception);
            }
            throw new DeploymentException(message + ": " + exception);
        }
        if (Log.isLogging(IGLUELoggingConstants.DEPLOY_EVENT)) {
            Log.log(IGLUELoggingConstants.DEPLOY_EVENT, (Object)(this.getAppName() + ": added service " + path));
        }
        if (this.serviceMonitor != null) {
            this.serviceMonitor.cycle();
        }
    }

    public boolean removeService(String path) throws DeploymentException {
        String descriptorPath = this.getDescriptorPath(path);
        File descriptor = new File(descriptorPath);
        if (!descriptor.exists()) {
            if (Log.isLogging(IGLUELoggingConstants.DEPLOY_EVENT)) {
                Log.log(IGLUELoggingConstants.DEPLOY_EVENT, (Object)(this.getAppName() + ": could not find descriptor " + descriptorPath));
            }
            return false;
        }
        boolean deleted = descriptor.delete();
        if (!deleted) {
            if (Log.isLogging(IGLUELoggingConstants.DEPLOY_EVENT)) {
                Log.log(IGLUELoggingConstants.DEPLOY_EVENT, (Object)(this.getAppName() + ": could not delete descriptor " + descriptorPath));
            }
            return false;
        }
        if (Log.isLogging(IGLUELoggingConstants.DEPLOY_EVENT)) {
            Log.log(IGLUELoggingConstants.DEPLOY_EVENT, (Object)(this.getAppName() + ": removed service " + path));
        }
        if (this.serviceMonitor != null) {
            this.serviceMonitor.cycle();
        }
        return true;
    }

    public void enableService(String name) throws DeploymentException {
        this.setPublish(name, true);
    }

    public void disableService(String name) throws DeploymentException {
        this.setPublish(name, false);
    }

    private void setPublish(String path, boolean enable) throws DeploymentException {
        String descriptorPath = this.getDescriptorPath(path);
        File file = new File(descriptorPath);
        if (!file.exists()) {
            throw new DeploymentException(this.getAppName() + ": could not find descriptor " + descriptorPath);
        }
        try {
            Document document = new Document(file);
            document.getRoot().setString("publish", enable ? "yes" : "no");
            document.write(file);
            if (this.serviceMonitor != null) {
                this.serviceMonitor.cycle();
            }
        }
        catch (Exception exception) {
            throw new DeploymentException(this.getAppName() + ": could not write descriptor " + descriptorPath);
        }
    }

    void descriptorModified(String descriptorPath, Document document) {
        String publishPath = this.getPublishPath(descriptorPath);
        ManagedService service = (ManagedService)this.get(publishPath);
        if (service != null) {
            service.stop();
        }
        this.descriptorAdded(descriptorPath, document);
    }

    void descriptorRemoved(String descriptorPath) {
        String publishPath = this.getPublishPath(descriptorPath);
        ManagedService service = (ManagedService)this.get(publishPath);
        if (service != null) {
            service.stop();
        }
    }

    void descriptorAdded(String descriptorPath, Document document) {
        block2: {
            try {
                String publishPath = this.getPublishPath(descriptorPath);
                ServiceDescriptor descriptor = new ServiceDescriptor(document);
                ManagedService service = new ManagedService(this, descriptor, publishPath);
                this.add(publishPath, service);
            }
            catch (Exception exception) {
                if (!Log.isLogging(ILoggingConstants.ERROR_EVENT)) break block2;
                Log.log(ILoggingConstants.ERROR_EVENT, this.getAppName() + ": could not add service from descriptor " + descriptorPath, exception);
            }
        }
    }

    private String getDescriptorPath(String publishPath) {
        String path = PathUtil.normalizeSlashes(publishPath);
        String filename = Strings.tail(path, File.separatorChar);
        path = !filename.equals(path) ? Strings.head(path, File.separatorChar) : "";
        if ((path = path + File.separatorChar + Strings.toFilename(filename)).startsWith(File.separator)) {
            path = path.substring(1);
        }
        if (!path.endsWith(".xml")) {
            path = path + ".xml";
        }
        return this.application.getServicesRoot() + path;
    }

    private String getPublishPath(String descriptorPath) {
        String path = descriptorPath.substring(this.application.getServicesRoot().length());
        path = Strings.head(path, '.');
        path = Strings.fromFilename(path);
        return Strings.replace(path, File.separator, "/");
    }

    public String getAppName() {
        return this.application.getAppName();
    }
}

