/*
 * Decompiled with CFR 0.152.
 */
package electric.fabric.config;

import electric.fabric.config.IFabricConfigConstants;
import electric.fabric.services.factory.IObjectFactory;
import electric.fabric.services.factory.ObjectFactories;
import electric.glue.IGLUELoggingConstants;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.product.IConfig;
import electric.util.reflect.Creator;
import electric.xml.Element;
import electric.xml.Elements;

public final class ObjectFactoryConfig
implements IConfig,
IFabricConfigConstants,
IGLUELoggingConstants {
    public void config(Element config) {
        Elements objectFactories = config.getElements("objectFactory");
        while (objectFactories.hasMoreElements()) {
            Element objectFactoryElement = objectFactories.next();
            try {
                IObjectFactory objectFactory = (IObjectFactory)Creator.newInstance(objectFactoryElement, null);
                ObjectFactories.addFactory(objectFactory);
            }
            catch (Throwable throwable) {
                if (!Log.isLogging(ILoggingConstants.STARTUP_EVENT)) continue;
                Log.log(ILoggingConstants.STARTUP_EVENT, (Object)("could not materialize object factory " + objectFactoryElement + "\n" + throwable.toString()));
            }
        }
    }
}

