/*
 * Decompiled with CFR 0.152.
 */
package electric.fabric.config;

import electric.fabric.config.IFabricConfigConstants;
import electric.glue.IGLUELoggingConstants;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.product.IConfig;
import electric.util.reflect.Creator;
import electric.xdb.server.XDBServer;
import electric.xdb.store.factory.IStoreFactory;
import electric.xml.Element;

public final class XDBConfig
implements IConfig,
IFabricConfigConstants,
IGLUELoggingConstants {
    public void config(Element config) {
        block6: {
            Element defaultDataStoreFactory;
            Element replicationFactor;
            Element xdbServers = config.getElement("xdbServers");
            if (xdbServers == null) {
                return;
            }
            Element syncCycle = xdbServers.getElement("syncCycle");
            if (syncCycle != null) {
                XDBServer.setSyncCycle(syncCycle.getLong() * 1000L);
            }
            if ((replicationFactor = xdbServers.getElement("replicationFactor")) != null) {
                XDBServer.setDefaultReplicationFactor(replicationFactor.getInt());
            }
            if ((defaultDataStoreFactory = config.getElement("defaultStoreFactory")) == null) {
                return;
            }
            try {
                IStoreFactory dataStoreFactory = (IStoreFactory)Creator.newInstance(defaultDataStoreFactory, null);
                XDBServer.setDefaultStoreFactory(dataStoreFactory);
            }
            catch (Throwable throwable) {
                if (!Log.isLogging(ILoggingConstants.STARTUP_EVENT)) break block6;
                Log.log(ILoggingConstants.STARTUP_EVENT, (Object)("could not materialize datastore factory " + defaultDataStoreFactory + "\n" + throwable.toString()));
            }
        }
    }
}

