/*
 * Decompiled with CFR 0.152.
 */
package electric.fabric.services.reference.balance;

import electric.fabric.Fabric;
import electric.fabric.IFabricConstants;
import electric.fabric.services.ServiceInfo;
import electric.fabric.services.ServiceManagerException;
import electric.soap.references.ISOAPReference;
import electric.soap.references.SOAPReferenceFactories;
import electric.soap.references.balance.IBalancer;
import electric.util.Context;
import electric.util.XURL;
import electric.wsdl.WSDL;
import java.util.Vector;

public class RoundRobin
implements IBalancer,
IFabricConstants {
    private String path;
    private ISOAPReference[] references;
    private int index;

    public RoundRobin(String path, Context proxyContext) throws ServiceManagerException {
        this.path = path;
        ServiceInfo[] serviceInfos = Fabric.getServiceManager().findServicesForPath(path);
        Vector<ISOAPReference> vector = new Vector<ISOAPReference>();
        int i = 0;
        while (i < serviceInfos.length) {
            try {
                String newPath = path + "&" + "service.wsdl" + "=" + serviceInfos[i].getWSDLURL();
                XURL endpoint = new XURL(newPath);
                WSDL wsdl = serviceInfos[i].getWSDL();
                ISOAPReference soapReference = SOAPReferenceFactories.newSOAPReference(endpoint, wsdl, proxyContext);
                vector.addElement(soapReference);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        this.references = new ISOAPReference[vector.size()];
        vector.copyInto(this.references);
    }

    public String toString() {
        return "RoundRobin( path=" + this.path + ", references=" + this.references.length + " )";
    }

    public synchronized ISOAPReference getCurrentReference() {
        if (this.references.length == 0) {
            throw new RuntimeException("balancing reference cannot locate service with path " + this.path);
        }
        return this.references[this.index];
    }

    public synchronized ISOAPReference getNextReference() {
        if (this.references.length == 0) {
            throw new RuntimeException("balancing reference cannot locate service with path " + this.path);
        }
        this.index = (this.index + 1) % this.references.length;
        return this.references[this.index];
    }
}

