/*
 * Decompiled with CFR 0.152.
 */
package electric.fabric.tools;

import electric.fabric.Fabric;
import electric.fabric.IFabricConstants;
import electric.server.http.HTTP;
import electric.util.tool.ToolUtil;

public class FabricServer
implements IFabricConstants {
    private static String url;

    public static void main(String[] args) {
        if (args.length == 0) {
            FabricServer.printUsage();
            return;
        }
        try {
            FabricServer.processArgs(args);
            FabricServer.startServer();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            FabricServer.printUsage();
            System.exit(-1);
        }
    }

    private static void printUsage() {
        System.out.println("usage: fabric [-h] url [-p port]");
        System.out.println();
        System.out.println("where:");
        System.out.println("  -Dname=value = set java system property");
        System.out.println("  url          = url for Fabric server");
        System.out.println("  -d           = delete previous contents (default is no)");
        System.out.println("  -h           = print help and exit");
        System.out.println("  -p           = port for broadcast discovery, (default is 9030)");
        System.out.println("  -r dir       = root directory for XML storage (default is none)");
        System.out.println();
        System.out.println("examples:");
        System.out.println();
        System.out.println("fabric http://localhost:8004/glue");
        System.out.println("  start Fabric on port 8004");
        System.out.println();
        System.out.println("fabric http://localhost:8004/glue -p 9065");
        System.out.println("  start Fabric on port 8004");
        System.out.println("  use port 9065 for broadcast discovery");
        System.out.println();
        System.out.println("fabric http://localhost:8004/glue -r storage -d");
        System.out.println("  start Fabric on port 8004");
        System.out.println("  use directory 'storage' for XML persistence");
        System.out.println("  delete previous contents");
        System.out.println();
        System.out.println("fabric http://localhost:8004/glue -r storage");
        System.out.println("  start Fabric on port 8004");
        System.out.println("  use directory 'storage' for XML persistence");
        System.out.println("  restore from current contents");
    }

    private static void processArgs(String[] args) throws Throwable {
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (!arg.startsWith("-")) {
                url = arg;
            } else {
                if (arg.length() == 1) {
                    throw new IllegalArgumentException("a plain - is not a valid argument");
                }
                switch (arg.charAt(1)) {
                    case 'd': {
                        System.setProperty("fabric.delete", "true");
                        break;
                    }
                    case 'D': {
                        ToolUtil.setProperty(arg);
                        break;
                    }
                    case 'h': {
                        FabricServer.printUsage();
                        System.exit(-1);
                    }
                    case 'p': {
                        System.setProperty("fabric.port", args[++i]);
                        break;
                    }
                    case 'r': {
                        System.setProperty("fabric.root", args[++i]);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("illegal argument " + arg.charAt(1));
                    }
                }
            }
            ++i;
        }
    }

    private static void startServer() throws Throwable {
        Fabric.join();
        HTTP.startup(url);
    }
}

