/*
 * Decompiled with CFR 0.152.
 */
package electric.glue.enterprise.config;

import electric.cluster.IClusterConstants;
import electric.cluster.lifecycle.LifecycleCommandFactory;
import electric.cluster.lifecycle.LivenessService;
import electric.glue.enterprise.config.IConfigConstants;
import electric.registry.Registry;
import electric.server.http.HTTP;
import electric.util.Context;
import electric.util.XURL;
import electric.util.product.IConfig;
import electric.util.string.Strings;
import electric.webserver.WebServer;
import electric.webserver.WebServers;
import electric.xml.Element;
import java.io.IOException;

public class WebServerConfig
implements IConfig,
IConfigConstants,
IClusterConstants {
    public void config(Element config) throws Throwable {
        boolean isMaster = Strings.getBoolean(Context.getSystemProperty("glue.master"), false);
        XURL xurl = this.resolveStartupUrl(isMaster, config);
        this.startWebServer(xurl.getHostAndPortXURL());
        WebServer webServer = WebServers.getWebServers()[0];
        LifecycleCommandFactory.setParentUrl(webServer.getXURL().getHostAndPortXURL().toString() + "/");
        Registry.publish("system/liveness", new LivenessService());
    }

    private void startWebServer(XURL url) throws IOException {
        HTTP.startup(url.toString());
    }

    private XURL resolveStartupUrl(boolean isMaster, Element config) throws Exception {
        String port = Context.getSystemProperty("glue.port");
        String url = "http://localhost:" + port;
        if (isMaster && port == null) {
            Element webServerElement = config.getElement("webServer");
            url = webServerElement.getString("url");
        } else if (!isMaster && port == null) {
            url = "http://localhost:0/";
        }
        return new XURL(url);
    }
}

