/*
 * Decompiled with CFR 0.152.
 */
package electric.servlet.dispatcher;

import electric.servlet.MappedServlet;
import electric.servlet.dispatcher.DispatcherRequest;
import electric.servlet.dispatcher.DispatcherResponse;
import electric.servlet.dispatcher.IncludeDispatcherRequest;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServletRequestDispatcher
implements RequestDispatcher {
    private MappedServlet mappedServlet;
    private String queryString;
    private boolean isNamedDispatcher;

    public ServletRequestDispatcher(MappedServlet mappedServlet, String queryString) {
        this(mappedServlet, queryString, false);
    }

    public ServletRequestDispatcher(MappedServlet mappedServlet, String queryString, boolean isNamedDispatcher) {
        this.mappedServlet = mappedServlet;
        this.queryString = queryString;
        this.isNamedDispatcher = isNamedDispatcher;
    }

    public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (response.isCommitted()) {
            throw new IllegalStateException("cannot forward, the response has already been committed");
        }
        response.reset();
        try {
            this.mappedServlet.config.service((ServletRequest)this.prepareRequest((HttpServletRequest)request, false), response);
        }
        catch (Exception exception) {
            this.checkException(exception);
        }
        response.flushBuffer();
    }

    public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        try {
            DispatcherResponse redirectResponse = new DispatcherResponse((HttpServletResponse)response);
            HttpServletRequest redirectRequest = this.prepareRequest((HttpServletRequest)request, true);
            this.mappedServlet.config.service((ServletRequest)redirectRequest, (ServletResponse)redirectResponse);
        }
        catch (Exception exception) {
            this.checkException(exception);
        }
    }

    protected HttpServletRequest prepareRequest(HttpServletRequest request, boolean include) {
        String servletPath = null;
        String pathInfo = null;
        if (!this.isNamedDispatcher) {
            servletPath = this.mappedServlet.servletPath;
            pathInfo = this.mappedServlet.pathInfo;
        } else {
            servletPath = request.getServletPath();
            pathInfo = request.getPathInfo();
        }
        String contextPath = this.mappedServlet.config.getContext().getPath();
        if (!include) {
            return new DispatcherRequest(request, contextPath, servletPath, pathInfo, this.queryString);
        }
        return new IncludeDispatcherRequest(request, contextPath, servletPath, pathInfo, this.queryString);
    }

    private void checkException(Exception exception) throws ServletException, IOException {
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        if (exception instanceof ServletException) {
            throw (ServletException)((Object)exception);
        }
        if (exception instanceof IOException) {
            throw (IOException)exception;
        }
        throw new ServletException(exception.toString(), (Throwable)exception);
    }

    public MappedServlet getMapppedServlet() {
        return this.mappedServlet;
    }
}

