/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.jms.reference;

import electric.glue.IGLUELoggingConstants;
import electric.server.jms.AsyncTransport;
import electric.server.jms.IJMSAdapter;
import electric.server.jms.IJMSConstants;
import electric.server.jms.JMS;
import electric.soap.SOAPMessage;
import electric.soap.SOAPOptimizations;
import electric.soap.references.ISOAPReference;
import electric.util.Context;
import electric.util.XURL;
import electric.util.array.ByteArray;
import electric.util.async.Async;
import electric.util.jms.JMSUtil;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.string.Strings;
import electric.wsdl.WSDL;
import java.rmi.RemoteException;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.naming.NamingException;

public final class SOAPToJMS
implements ISOAPReference,
IJMSConstants,
IGLUELoggingConstants {
    private static QueueConnectionFactory appWideConnFactory;
    private static String appWideConnFactoryName;
    private XURL endpoint;
    private WSDL wsdl;
    private QueueConnection queueConnection;
    private QueueSession queueSession;
    private Queue requestQueue;
    private Queue responseQueue;
    private QueueSender queueSender;
    private boolean isInitialized;
    private Context proxyContext;

    public SOAPToJMS(XURL endpoint, WSDL wsdl, Context proxyContext) {
        this.endpoint = endpoint;
        this.wsdl = wsdl;
        this.proxyContext = proxyContext;
    }

    public String toString() {
        return "SOAPToJMS( " + this.endpoint + " )";
    }

    protected void finalize() {
        block2: {
            try {
                this.queueSender.close();
                this.queueSession.close();
            }
            catch (JMSException exception) {
                if (!Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) break block2;
                Log.log(ILoggingConstants.EXCEPTION_EVENT, "unable to close queue sender and queue session", exception);
            }
        }
    }

    public WSDL getWSDL() {
        return this.wsdl;
    }

    public XURL getEndpoint() {
        return this.endpoint;
    }

    public SOAPMessage handle(SOAPMessage request, Context messageContext) throws RemoteException, SecurityException {
        BytesMessage message;
        Async async = (Async)messageContext.getProperty("async");
        String requestQueueName = (String)Context.getProperty(this.proxyContext, "jmsQueue");
        String responseQueueName = (String)Context.getProperty(this.proxyContext, "jmsResponseQueue");
        String queueFactory = (String)Context.getProperty(this.proxyContext, "jmsQueueConnectionFactory");
        this.validateAdminObjects(requestQueueName, queueFactory);
        String[] admObj = null;
        try {
            admObj = JMS.findAdminObjects(requestQueueName, queueFactory, Strings.getEndpoint(this.endpoint.getFile()));
        }
        catch (Exception exception) {
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, "unable to find jms admin objects", exception);
            }
            throw new RemoteException("unable to find admin objects. " + exception.toString());
        }
        queueFactory = admObj[0];
        requestQueueName = admObj[1];
        if (responseQueueName == null) {
            responseQueueName = requestQueueName;
        }
        try {
            this.createJMSObjects(queueFactory, requestQueueName, responseQueueName, this.proxyContext);
        }
        catch (Exception exception) {
            String errorMsg = "unable to create jms object hierarchy. ";
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, errorMsg, exception);
            }
            throw new RemoteException(errorMsg + exception.toString());
        }
        try {
            message = this.queueSession.createBytesMessage();
        }
        catch (JMSException exception) {
            String errorMsg = "unable to create JMS BytesMessage. ";
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, errorMsg, exception);
            }
            throw new RemoteException(errorMsg + exception.toString());
        }
        try {
            ByteArray byteArray = request.getByteArray();
            message.writeBytes(byteArray.bytes, byteArray.offset, byteArray.length);
        }
        catch (Exception exception) {
            String errorMsg = "unable to write message bytes to BytesMessage. ";
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, errorMsg, exception);
            }
            throw new RemoteException(errorMsg + exception.toString());
        }
        SOAPOptimizations optimizations = request.getOptimizations();
        try {
            message.setJMSReplyTo((Destination)this.responseQueue);
            message.setStringProperty("serviceURN", this.endpoint.toString());
            if (optimizations.getDescription() != null) {
                message.setStringProperty("GLUEOptimized", optimizations.getDescription());
            }
        }
        catch (Exception exception) {
            String errorMsg = "unable to set JMS 'Reply To' property on the outgoing message. ";
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, errorMsg, exception);
            }
            throw new RemoteException(errorMsg + exception.toString());
        }
        if (async == null) {
            try {
                this.queueSender.send((Message)message);
                String selector = "JMSCorrelationID = '" + message.getJMSMessageID() + "'";
                QueueReceiver receiver = this.queueSession.createReceiver(this.responseQueue, selector);
                BytesMessage response = (BytesMessage)receiver.receive();
                receiver.close();
                SOAPMessage soapResponse = new SOAPMessage();
                byte[] bytes = JMSUtil.getMessageBytes(response);
                soapResponse.setBytes(bytes, optimizations, null);
                return soapResponse;
            }
            catch (Exception exception) {
                String errorMsg = "exception while sending invocation request .";
                if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                    Log.log(ILoggingConstants.EXCEPTION_EVENT, errorMsg, exception);
                }
                throw new RemoteException(errorMsg + exception.toString());
            }
        }
        try {
            message.setStringProperty("jmsResponseQueue", responseQueueName);
            this.queueSender.send((Message)message);
            String selector = "JMSCorrelationID = '" + message.getJMSMessageID() + "'";
            AsyncTransport transport = new AsyncTransport();
            QueueSession replySession = this.queueConnection.createQueueSession(false, 1);
            QueueReceiver receiver = JMS.createReceiver(replySession, this.responseQueue, selector);
            transport.setQueueName(responseQueueName);
            transport.setQueueSession(replySession);
            transport.setQueueReceiver(receiver);
            transport.setConnFactoryName(appWideConnFactoryName);
            async.setTransportHandler(transport);
        }
        catch (JMSException exception) {
            String errorMsg = "exception while sending invocation request .";
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, errorMsg, exception);
            }
            throw new RemoteException(errorMsg + exception.toString());
        }
        return null;
    }

    private void validateAdminObjects(String requestQueueName, String queueFactory) {
        if (!(requestQueueName == null && queueFactory == null || requestQueueName != null && queueFactory != null)) {
            throw new IllegalArgumentException("invalid configuration information. either all or no values for queues and queue connection factory must be specified");
        }
    }

    private synchronized void createJMSObjects(String destFactory, String requestQueueName, String responseQueueName, Context proxyContext) throws JMSException, NamingException {
        if (this.isInitialized) {
            return;
        }
        boolean shouldCacheCnx = this.shouldCacheConn(proxyContext);
        IJMSAdapter jmsAdapter = JMS.getAdapter();
        jmsAdapter.startup(proxyContext);
        if (responseQueueName == null) {
            responseQueueName = requestQueueName;
        }
        appWideConnFactoryName = destFactory;
        if (appWideConnFactory == null) {
            appWideConnFactory = jmsAdapter.getQueueConnectionFactory(destFactory, false);
        }
        if (this.queueConnection == null) {
            this.queueConnection = JMS.getQConnection(appWideConnFactory, shouldCacheCnx);
        }
        if (this.queueSession == null) {
            this.queueSession = JMS.createQSession(this.queueConnection);
        }
        if (this.requestQueue == null) {
            this.requestQueue = jmsAdapter.getQueue(requestQueueName, false);
        }
        if (this.responseQueue == null) {
            this.responseQueue = jmsAdapter.getQueue(responseQueueName, false);
        }
        if (this.queueSender == null) {
            this.queueSender = JMS.createSender(this.queueSession, this.requestQueue);
        }
        this.queueConnection.start();
        this.isInitialized = true;
    }

    private boolean shouldCacheConn(Context proxyContext) {
        Object shouldCacheProp = Context.getProperty(proxyContext, "jmsReuseJMSQueueConnections");
        return shouldCacheProp == null || !shouldCacheProp.equals("no");
    }
}

