/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.security.guards;

import electric.glue.IGLUELoggingConstants;
import electric.soap.ISOAPConstants;
import electric.soap.SOAPMessage;
import electric.soap.security.IWSSConstants;
import electric.soap.security.encryption.WSSEncryption;
import electric.soap.security.guards.IWSSGuard;
import electric.soap.security.signature.xml.ElementReference;
import electric.soap.security.util.SecurityXPathFactory;
import electric.util.log.Log;
import electric.xml.Node;
import electric.xml.xpath.NodeSet;
import java.util.Vector;

public class EncryptionGuard
implements IWSSGuard,
ISOAPConstants,
IWSSConstants,
IGLUELoggingConstants {
    private WSSEncryption encryptionSpec;
    private boolean allMustAuthorize;

    public EncryptionGuard(WSSEncryption encryptionSpec) {
        this.encryptionSpec = encryptionSpec;
    }

    public boolean authorize(SOAPMessage message, Vector signatures, Vector encryptions, Vector principalList, Vector authorizationCredentials) {
        try {
            int authCount = 0;
            int i = 0;
            while (i < encryptions.size()) {
                WSSEncryption encryption = (WSSEncryption)encryptions.elementAt(i);
                if (!this.authorize(message, encryption, principalList)) {
                    return false;
                }
                ++authCount;
                ++i;
            }
            if (this.allMustAuthorize) {
                if (authCount != encryptions.size()) {
                    return false;
                }
            } else if (authCount == 0) {
                if (Log.isLogging(IGLUELoggingConstants.SECURITY_DETAIL_EVENT)) {
                    Log.log(IGLUELoggingConstants.SECURITY_DETAIL_EVENT, (Object)"encryption guard authorization failed, no part of message decrypted");
                }
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    private boolean authorize(SOAPMessage message, WSSEncryption encryption, Vector principalList) throws Exception {
        ElementReference reference = this.encryptionSpec.getReference();
        NodeSet requiredNodes = this.getReferencedNodes(message, reference);
        if (requiredNodes == null || requiredNodes.getLength() == 0) {
            if (Log.isLogging(IGLUELoggingConstants.SECURITY_DETAIL_EVENT)) {
                Log.log(IGLUELoggingConstants.SECURITY_DETAIL_EVENT, (Object)"encryption guard failed, no required nodes");
            }
            return false;
        }
        NodeSet decryptedNodes = encryption.getDecryptedNodes();
        boolean matches = this.setsMatch(requiredNodes, decryptedNodes);
        if (!matches && Log.isLogging(IGLUELoggingConstants.SECURITY_DETAIL_EVENT)) {
            Log.log(IGLUELoggingConstants.SECURITY_DETAIL_EVENT, (Object)("encryption guard authorization failed, required nodes not signed: " + this.encryptionSpec.getReference().getPath()));
        }
        return matches;
    }

    private boolean setsMatch(NodeSet nodeSet0, NodeSet nodeSet1) {
        if (nodeSet0 == nodeSet1) {
            return true;
        }
        if (nodeSet0.getLength() != nodeSet1.getLength()) {
            return false;
        }
        if (nodeSet0.getLength() == 1 && nodeSet1.getLength() == 1) {
            return nodeSet0.item(0) == nodeSet1.item(0);
        }
        NodeSet nodeSet1Copy = new NodeSet(nodeSet1);
        int i = 0;
        while (i < nodeSet0.getLength()) {
            Node nodei = (Node)nodeSet0.item(i);
            int index = nodeSet1Copy.indexOf(nodei);
            if (index == -1) {
                return false;
            }
            nodeSet1.remove(index);
            ++i;
        }
        return true;
    }

    private NodeSet getReferencedNodes(SOAPMessage message, ElementReference signedReference) throws Exception {
        if (signedReference == null) {
            return null;
        }
        return SecurityXPathFactory.getSimplePath(message.getRoot(), signedReference);
    }

    public WSSEncryption getEncryptionSpec() {
        return this.encryptionSpec;
    }

    public void setEncryptionSpec(WSSEncryption encryptionSpec) {
        this.encryptionSpec = encryptionSpec;
    }

    public boolean matchesReference(ElementReference reference) {
        if (reference == null) {
            return false;
        }
        String thisPath = this.encryptionSpec.getReference().getPath();
        String compPath = reference.getPath();
        return thisPath.equals(compPath);
    }
}

