/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.security.references;

import electric.glue.IGLUEContextConstants;
import electric.glue.IGLUELoggingConstants;
import electric.soap.SOAPException;
import electric.soap.SOAPMessage;
import electric.soap.references.chain.ChainedSOAPReference;
import electric.soap.security.IWSSConstants;
import electric.soap.security.SOAPSecurityException;
import electric.soap.security.WSSContext;
import electric.soap.security.encryption.WSSEncryptionProcessor;
import electric.soap.security.signature.WSSSignatureProcessor;
import electric.soap.security.tokens.SecurityTokenProcessor;
import electric.util.Context;
import electric.util.XURL;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.wsdl.WSDL;
import electric.xml.Element;
import electric.xml.IXMLConstants;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Vector;

public class SecuritySOAPReference
extends ChainedSOAPReference
implements IWSSConstants,
IXMLConstants,
IGLUEContextConstants,
IGLUELoggingConstants {
    private SecurityTokenProcessor tokenProcessor = new SecurityTokenProcessor();
    private WSSSignatureProcessor signatureProcessor = new WSSSignatureProcessor(this.tokenProcessor);
    private WSSEncryptionProcessor encryptionProcessor = new WSSEncryptionProcessor(this.tokenProcessor);
    private Context proxyContext;

    public SecuritySOAPReference(Context proxyContext) {
        this.proxyContext = proxyContext;
    }

    public SOAPMessage handle(SOAPMessage request, Context messageContext) throws RemoteException, SecurityException {
        WSSContext wss = (WSSContext)this.proxyContext.getProperty("wssContext");
        if (wss == null || !WSSContext.isEnabled()) {
            return this.nextReference.handle(request, messageContext);
        }
        return this.handleSecurity(request, wss, messageContext);
    }

    public SOAPMessage handleSecurity(SOAPMessage request, WSSContext wss, Context messageContext) {
        SOAPMessage response;
        block3: {
            response = null;
            try {
                request.deoptimize();
                Element securityElement = new Element("wsse", "Security", "http://schemas.xmlsoap.org/ws/2002/12/secext");
                securityElement.setNamespace("wsse", "http://schemas.xmlsoap.org/ws/2002/12/secext");
                Element msgHeader = request.addHeader();
                msgHeader.addChild(securityElement);
                this.outgoing(request, wss, securityElement);
                response = this.nextReference.handle(request, messageContext);
                if (response == null) {
                    return null;
                }
                response.deoptimize();
                this.incoming(response, wss);
            }
            catch (Exception exception) {
                if (!Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) break block3;
                Log.log(ILoggingConstants.EXCEPTION_EVENT, "SOAP Security", exception);
            }
        }
        return response;
    }

    private void outgoing(SOAPMessage message, WSSContext wss, Element securityElement) throws SOAPSecurityException, Exception {
        this.tokenProcessor.addTokens(message, wss, securityElement);
        Hashtable tokenToId = new Hashtable();
        this.signatureProcessor.addTokens(message, wss, securityElement, tokenToId);
        this.signatureProcessor.addSignatures(message, wss, securityElement);
        this.encryptionProcessor.addEncryptionCertificates(message, wss, securityElement, tokenToId);
        this.encryptionProcessor.addEncryptions(message, wss, securityElement, tokenToId);
    }

    private void incoming(SOAPMessage message, WSSContext wss) throws SOAPException {
        Vector tokenList = this.tokenProcessor.readTokens(message, wss);
        Vector principalList = new Vector();
        boolean authorized = wss.in.authenticate(message, tokenList, principalList);
        Vector encryptions = new Vector();
        this.encryptionProcessor.decrypt(message, encryptions, wss.in.guards());
        Vector signatures = new Vector();
        this.signatureProcessor.validateSignatures(message, wss, signatures, tokenList);
        boolean authenticated = true;
        if (!authenticated) {
            if (Log.isLogging(IGLUELoggingConstants.SECURITY_DEBUG_EVENT)) {
                Log.log(IGLUELoggingConstants.SECURITY_DEBUG_EVENT, (Object)"SecurityHandler.intercept():!authenticated");
            }
            String detail = "<detail>SECURITY EXCEPTION</detail>";
            throw new SOAPException("security", "Server", null, detail);
        }
    }

    public WSDL getWSDL() {
        return this.nextReference.getWSDL();
    }

    public XURL getEndpoint() {
        return this.nextReference.getEndpoint();
    }
}

