/*
 * Decompiled with CFR 0.152.
 */
package electric.uddi;

import electric.uddi.IUDDIConstants;
import electric.uddi.IUDDIServer;
import electric.uddi.UDDIException;
import electric.xml.io.IReader;
import electric.xml.io.ISerializable;
import electric.xml.io.IWriter;
import java.io.IOException;

public final class DispositionReport
implements ISerializable,
IUDDIConstants {
    private static IUDDIServer server;
    private int errNo;
    private String errCode;
    private String errInfo;
    private String siteOperator;

    public DispositionReport() {
    }

    public DispositionReport(int errNo) {
        this.errNo = errNo;
        this.errCode = UDDIException.getExceptionName(errNo);
        this.errInfo = UDDIException.getExceptionDescription(errNo);
        this.siteOperator = DispositionReport.getSiteOperator();
    }

    public DispositionReport(int errNo, String errCode, String errInfo, String siteOperator) {
        this.errNo = errNo;
        this.errCode = errCode;
        this.errInfo = errInfo;
        this.siteOperator = siteOperator;
    }

    public String toString() {
        return "DispositionReport( errno=" + this.errNo + ", errCode=" + this.errCode + ", errInfo=" + this.errInfo + ", operator=" + this.siteOperator + " )";
    }

    public void write(IWriter writer) throws IOException {
        IWriter child = writer.writeElement("dispositionReport");
        if (this.siteOperator != null) {
            writer.writeAttribute("operator", this.siteOperator);
        }
        IWriter result = child.writeElement("result");
        result.writeAttribute("errno", Integer.toString(this.errNo));
        IWriter info = result.writeElement("errInfo");
        info.writeAttribute("errCode", this.errCode);
        info.writeText(this.errInfo);
    }

    public void read(IReader reader) throws IOException {
        this.siteOperator = reader.readAttributeValue("operator");
        IReader child = reader.getReader("result");
        this.errNo = Integer.parseInt(child.readAttributeValue("errno"));
        IReader info = child.getReader("errInfo");
        this.errCode = info.readAttributeValue("errCode");
        this.errInfo = info.readString();
    }

    public static void setUDDIServer(IUDDIServer server) {
        DispositionReport.server = server;
    }

    private static String getSiteOperator() {
        return server != null ? server.getOperator() : null;
    }
}

