/*
 * Decompiled with CFR 0.152.
 */
package electric.util;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;

public final class XURL
implements Serializable {
    private static final int DEFAULT_HTTP_PORT = 80;
    private static final int DEFAULT_HTTPS_PORT = 443;
    private static InetAddress localHostAddress;
    private String protocol;
    private String host;
    private int port = -1;
    private String file;
    private String reference;
    private transient int hashCode = -1;
    private transient String string;
    private transient boolean initializedHostAddress;
    private transient InetAddress hostAddress;
    private transient boolean initializedHasLocalHost;
    private transient boolean hasLocalHost;

    public XURL() {
    }

    public XURL(String xurl) throws MalformedURLException {
        int slashes;
        String url = xurl.trim();
        int length = url.length();
        int index = 0;
        int n = slashes = url.startsWith("?") ? -1 : url.indexOf("//");
        if (XURL.isFileURL(url)) {
            this.protocol = "file";
            index = 6;
        } else if (slashes != -1) {
            int colon;
            int start;
            if (slashes > 0) {
                this.protocol = url.substring(0, slashes - 1);
            }
            if ((index = url.indexOf(47, start = slashes + 2)) == -1) {
                index = length;
            }
            if ((colon = url.indexOf(58, start)) == -1 || colon > index) {
                this.host = url.substring(start, index);
            } else {
                this.host = url.substring(start, colon);
                try {
                    this.port = Integer.parseInt(url.substring(colon + 1, index));
                }
                catch (NumberFormatException exception) {
                    throw new MalformedURLException("Malformed URL " + url);
                }
            }
        }
        if (index < length) {
            int hash = url.indexOf(35, index);
            if (hash == -1) {
                this.file = url.substring(index, length);
            } else {
                this.file = url.substring(index, hash);
                this.reference = url.substring(hash + 1);
            }
        }
        if ("localhost".equalsIgnoreCase(this.host) && localHostAddress != null) {
            this.host = localHostAddress.getHostAddress();
        }
    }

    public XURL(String protocol, String host, int port, String file, String reference) {
        this.protocol = protocol;
        this.host = host;
        this.port = port;
        this.file = file;
        this.reference = reference;
    }

    public XURL(XURL xurl) {
        this.protocol = xurl.protocol;
        this.host = xurl.host;
        this.port = xurl.port;
        this.file = xurl.file;
        this.reference = xurl.reference;
        this.hashCode = xurl.hashCode;
        this.initializedHostAddress = xurl.initializedHostAddress;
        this.hostAddress = xurl.hostAddress;
        this.string = xurl.string;
        this.initializedHasLocalHost = xurl.initializedHasLocalHost;
        this.hasLocalHost = xurl.hasLocalHost;
    }

    public synchronized String toString() {
        if (this.string != null) {
            return this.string;
        }
        StringBuffer buffer = new StringBuffer();
        if (this.protocol != null) {
            buffer.append(this.protocol).append(':');
        }
        if (this.host != null) {
            buffer.append("//").append(this.host);
            if (this.port != -1) {
                buffer.append(':').append(this.port);
            }
        }
        if (this.file != null) {
            buffer.append(this.file);
            if (this.reference != null) {
                buffer.append('#').append(this.reference);
            }
        }
        this.string = buffer.toString();
        return this.string;
    }

    public synchronized int hashCode() {
        int fileHashCode;
        if (this.hashCode != -1) {
            return this.hashCode;
        }
        int n = fileHashCode = this.file == null ? 0 : this.file.hashCode();
        this.hashCode = this.hasLocalHost() ? "localhost".hashCode() + this.port + fileHashCode : (this.getHostAddress() != null ? this.getHostAddress().hashCode() + this.port + fileHashCode : (this.host != null ? this.host.hashCode() + this.port + fileHashCode : this.port + fileHashCode));
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof XURL)) {
            return false;
        }
        XURL xurl = (XURL)object;
        if (this.hashCode() != xurl.hashCode()) {
            return false;
        }
        if (this.file != null && !this.file.equals(xurl.file)) {
            return false;
        }
        if (this.file == null && xurl.file != null) {
            return false;
        }
        if (this.protocol != null && !this.protocol.equalsIgnoreCase(xurl.protocol)) {
            return false;
        }
        if (this.protocol == null && xurl.protocol != null) {
            return false;
        }
        if (this.reference != null && !this.reference.equals(xurl.reference)) {
            return false;
        }
        if (this.reference == null && xurl.reference != null) {
            return false;
        }
        if (this.port != xurl.port) {
            return false;
        }
        if (this.hasLocalHost() && xurl.hasLocalHost()) {
            return true;
        }
        if (this.getHostAddress() != null && xurl.getHostAddress() != null) {
            return this.getHostAddress().equals(xurl.getHostAddress());
        }
        if (this.host != null && !this.host.equalsIgnoreCase(xurl.host)) {
            return false;
        }
        return this.host != null || xurl.host == null;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public synchronized InetAddress getHostAddress() {
        block3: {
            if (this.initializedHostAddress) {
                return this.hostAddress;
            }
            this.initializedHostAddress = true;
            if (this.host == null) break block3;
            try {
                this.hostAddress = InetAddress.getByName(this.host);
            }
            catch (Exception exception) {}
        }
        return this.hostAddress;
    }

    public int getPort() {
        if (this.port != -1) {
            return this.port;
        }
        if ("http".equalsIgnoreCase(this.protocol)) {
            return 80;
        }
        if ("https".equalsIgnoreCase(this.protocol)) {
            return 443;
        }
        return -1;
    }

    public String getFile() {
        return this.file;
    }

    public String getReference() {
        return this.reference;
    }

    public XURL getHostXURL() {
        if (this.port == -1 && this.file == null && this.reference == null) {
            return this;
        }
        return new XURL(this.protocol, this.host, -1, null, null);
    }

    public XURL getHostAndPortXURL() {
        if (this.file == null && this.reference == null) {
            return this;
        }
        return new XURL(this.protocol, this.host, this.port, null, null);
    }

    public static XURL valueOf(String string) throws IllegalArgumentException {
        try {
            return new XURL(string);
        }
        catch (MalformedURLException exception) {
            throw new IllegalArgumentException("malformed URL " + string);
        }
    }

    public static boolean hasProtocol(String path) {
        return path.indexOf("://") != -1 || XURL.isFileURL(path);
    }

    public static String getProtocol(String path) {
        int index = path.indexOf("://");
        if (index != -1) {
            return path.substring(0, index).toLowerCase();
        }
        if (XURL.isFileURL(path)) {
            return "file";
        }
        return null;
    }

    public static boolean isFileURL(String path) {
        return path.toLowerCase().startsWith("file:/");
    }

    private static void initLocalHostAddress() {
        try {
            localHostAddress = InetAddress.getLocalHost();
            if (localHostAddress.getHostAddress().startsWith("3.0.0.")) {
                localHostAddress = InetAddress.getByName("localhost");
            }
        }
        catch (UnknownHostException exception) {
        }
        catch (SecurityException exception) {}
    }

    public static InetAddress getLocalHostAddress() {
        return localHostAddress;
    }

    public synchronized boolean hasLocalHost() {
        if (this.initializedHasLocalHost) {
            return this.hasLocalHost;
        }
        this.initializedHasLocalHost = true;
        if (this.host == null || this.host.equals("")) {
            this.hasLocalHost = true;
        } else if (this.host.equalsIgnoreCase("localhost") || this.host.equals("127.0.0.1")) {
            this.hasLocalHost = true;
        } else if (localHostAddress == null) {
            this.hasLocalHost = false;
        } else if (this.getHostAddress() != null && this.getHostAddress().equals(localHostAddress)) {
            this.hasLocalHost = true;
        } else if (this.host.equalsIgnoreCase(localHostAddress.getHostName()) || this.host.equalsIgnoreCase(localHostAddress.getHostAddress())) {
            this.hasLocalHost = true;
        }
        return this.hasLocalHost;
    }

    static {
        XURL.initLocalHostAddress();
    }
}

