/*
 * Decompiled with CFR 0.152.
 */
package electric.util.thread;

public class Monitor
implements Runnable {
    public static int INTERRUPTED = 1;
    public static int FINISHED = 2;
    private long milliseconds;
    private Runnable runnable;
    private Thread parentThread;

    private Monitor(long milliseconds, Runnable runnable, Thread parentThread) {
        this.milliseconds = milliseconds;
        this.runnable = runnable;
        this.parentThread = parentThread;
    }

    public static int start(long milliseconds, Runnable runnable) {
        int returnCode = FINISHED;
        Thread threadToWatch = new Thread(new Monitor(milliseconds, runnable, Thread.currentThread()));
        threadToWatch.start();
        try {
            Thread.sleep(milliseconds);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (threadToWatch.isAlive()) {
            threadToWatch.interrupt();
            returnCode = INTERRUPTED;
        }
        return returnCode;
    }

    public void run() {
        this.runnable.run();
        this.parentThread.interrupt();
    }
}

