/*
 * Decompiled with CFR 0.152.
 */
package electric.wsdl;

import electric.util.named.IQNamed;
import electric.wsdl.IWSDLConstants;
import electric.wsdl.Part;
import electric.wsdl.WSDL;
import electric.wsdl.WSDLException;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.io.Namespaces;
import electric.xml.io.schema.SchemaException;
import java.util.Vector;

public final class Message
implements IQNamed,
IWSDLConstants {
    private WSDL wsdl;
    private String targetNamespace;
    private String name;
    private Part[] parts = new Part[0];

    public Message() {
    }

    public Message(WSDL wsdl, String targetNamespace, String name, Part[] parts) {
        this.wsdl = wsdl;
        this.targetNamespace = targetNamespace;
        this.name = name;
        this.parts = parts;
        int i = 0;
        while (i < parts.length) {
            parts[i].setMessage(this);
            ++i;
        }
    }

    public Message(WSDL wsdl, String targetNamespace, Element root) throws WSDLException, SchemaException {
        this.wsdl = wsdl;
        this.targetNamespace = targetNamespace;
        this.name = root.getAttributeValue("name");
        if (this.name == null) {
            throw new WSDLException("<message> is missing name attribute");
        }
        Elements partElements = root.getElements("part");
        this.parts = new Part[partElements.size()];
        int i = 0;
        while (i < this.parts.length) {
            this.parts[i] = new Part(this, partElements.next());
            ++i;
        }
    }

    public String toString() {
        return "Message( " + this.targetNamespace + ":" + this.name + " )";
    }

    public WSDL getWSDL() {
        return this.wsdl;
    }

    public Namespaces getNamespaces() {
        return this.wsdl.getNamespaces();
    }

    public String getNamespace() {
        return this.targetNamespace;
    }

    public String getName() {
        return this.name;
    }

    public Part getPart(String name) {
        int i = 0;
        while (i < this.parts.length) {
            if (this.parts[i].getName().equals(name)) {
                return this.parts[i];
            }
            ++i;
        }
        return null;
    }

    public Part getPart(int index) {
        return this.parts[index];
    }

    public int getPartCount() {
        return this.parts.length;
    }

    public Part[] getParts() {
        return this.parts;
    }

    public void addDependencies(Vector dependencies) {
        int i = 0;
        while (i < this.parts.length) {
            dependencies.addElement(this.parts[i].getType());
            ++i;
        }
    }

    public void writeWSDL(Element definitions) {
        String wsdlPrefix = definitions.getNamespacePrefix("http://schemas.xmlsoap.org/wsdl/");
        Element message = definitions.addElement(wsdlPrefix, "message");
        message.setAttribute("name", this.name);
        int i = 0;
        while (i < this.parts.length) {
            this.parts[i].writeWSDL(message);
            ++i;
        }
    }
}

