/*
 * Decompiled with CFR 0.152.
 */
package electric.xml;

import electric.util.array.ArrayUtil;
import electric.util.named.IQNamed;
import electric.xml.Element;
import electric.xml.NamespaceException;
import electric.xml.Node;
import electric.xml.NodeReader;
import electric.xml.NodeWriter;
import electric.xml.Text;
import java.io.IOException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;

public final class Attribute
extends Node
implements IQNamed,
Attr {
    private static char quoteCharacter = (char)39;
    private Element element;
    private String prefix;
    String namespace;
    String name;
    String value;
    boolean isNamespace;
    boolean isId;
    private boolean raw;

    public Attribute() {
    }

    public Attribute(String name, String value) {
        this.name = name;
        this.value = value;
        this.initialize();
    }

    public Attribute(String prefix, String name, String value) {
        this.prefix = prefix;
        this.name = name;
        this.value = value;
        this.initialize();
    }

    public Attribute(Attribute attribute) {
        this.prefix = attribute.prefix;
        this.namespace = attribute.namespace;
        this.name = attribute.name;
        this.value = attribute.value;
        this.isNamespace = attribute.isNamespace;
        this.isId = attribute.isId;
        this.raw = attribute.raw;
    }

    Attribute(String name, String value, boolean isNamespace) {
        this.isNamespace = isNamespace;
        this.value = value;
        if (isNamespace) {
            if (name.equals("")) {
                this.name = "xmlns";
            } else {
                this.prefix = "xmlns";
                this.name = name;
            }
        } else {
            this.name = name;
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Attribute)) {
            return false;
        }
        Attribute attribute = (Attribute)object;
        return attribute.name.equals(this.name) && attribute.value.equals(this.value) && ArrayUtil.equals(attribute.namespace, this.namespace);
    }

    public int hashCode() {
        return this.name.hashCode() + this.value.hashCode();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.prefix != null && !this.prefix.equals("")) {
            buffer.append(this.prefix).append(':');
        }
        buffer.append(this.name).append('=').append(quoteCharacter).append(this.value).append(quoteCharacter);
        return buffer.toString();
    }

    public Object clone() {
        return new Attribute(this);
    }

    public String getLocalName() {
        return this.name;
    }

    public String getName() {
        return this.prefix == null ? this.name : this.prefix + ":" + this.name;
    }

    public String getQName() {
        return this.namespace == null ? this.name : this.namespace + ":" + this.name;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public boolean isNamespace() {
        return this.isNamespace;
    }

    public boolean hasName(String namespace, String name) {
        if (!this.name.equals(name)) {
            return false;
        }
        if (namespace == null) {
            return true;
        }
        if (this.namespace == null) {
            return false;
        }
        return this.namespace.equals(namespace);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void initialize(String prefix, String name, String value) {
        this.prefix = prefix;
        this.name = name;
        this.value = value;
        this.initialize();
    }

    public void initialize() {
        if ("xmlns".equals(this.name) || "xmlns".equals(this.prefix)) {
            this.isNamespace = true;
            this.namespace = "http://www.w3.org/2000/xmlns/";
        } else if ("id".equals(this.name) || "Id".equals(this.name)) {
            this.isId = true;
        }
    }

    void resolve(Element element) throws NamespaceException {
        this.element = element;
        if (this.prefix != null && !this.isNamespace && !this.prefix.equals("xml")) {
            this.namespace = element.getNamespace(this.prefix);
            if (this.namespace == null) {
                throw new NamespaceException("could not find namespace with prefix " + this.prefix);
            }
        }
    }

    public Element getElement() {
        return this.element;
    }

    public void setRaw(boolean flag) {
        this.raw = flag;
    }

    public boolean getRaw() {
        return this.raw;
    }

    public int size() {
        if (this.prefix == null) {
            return this.name.length() + 3 + this.value.length();
        }
        return this.prefix.length() + 1 + this.name.length() + 3 + this.value.length();
    }

    public void read(NodeReader reader) throws IOException, NamespaceException {
        this.name = reader.readToken();
        if (reader.peek() == 58) {
            this.prefix = this.name;
            reader.read();
            this.name = reader.readToken();
        }
        reader.readChar(61);
        reader.skipWhitespace();
        int ch = reader.read();
        if (ch == 34) {
            this.value = reader.readToPattern("\"", 66);
        } else if (ch == 39) {
            this.value = reader.readToPattern("'", 66);
        } else {
            throw new IOException("missing quote at start of attribute");
        }
        this.initialize();
    }

    public void write(NodeWriter writer) throws IOException {
        if (this.prefix != null) {
            writer.write(this.prefix);
            writer.write(':');
        }
        writer.write(this.name);
        writer.write("=" + quoteCharacter);
        if (this.value == null) {
            writer.write("null");
        } else if (this.raw) {
            writer.write(this.value);
        } else {
            Text.writeWithSubstitution(writer, this.value);
        }
        writer.write(quoteCharacter);
    }

    public short getNodeType() {
        return 2;
    }

    public String getNodeName() {
        return this.getName();
    }

    public String getNodeValue() {
        return this.value;
    }

    public void setNodeValue(String nodeValue) {
        this.value = nodeValue;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public org.w3c.dom.Node cloneNode(boolean deep) {
        return new Attribute(this);
    }

    public Document getOwnerDocument() {
        return this.element != null ? this.element.getOwnerDocument() : null;
    }

    public String getNamespaceURI() {
        return this.namespace;
    }

    public org.w3c.dom.Element getOwnerElement() {
        return this.element;
    }

    public boolean getSpecified() {
        return true;
    }

    public static char getQuoteCharacter() {
        return quoteCharacter;
    }

    public static void setQuoteCharacter(char quoteCharacter) {
        if (quoteCharacter != '\'' && quoteCharacter != '\"') {
            throw new IllegalArgumentException("Quotes can only be ' or \".");
        }
        Attribute.quoteCharacter = quoteCharacter;
    }
}

